<?php

namespace App\Http\Controllers;

use App\Models\CourseEnquery;
use Illuminate\Http\Request;

class CourseEnqueryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $course_enquerys = CourseEnquery::orderBy('id','desc')->where('delete_status','0')->get();
        return view('backend.course_enquiry.index', compact('course_enquerys'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         $course_enquery=$request->all();

        $validation=$request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required'
            ]);

        CourseEnquery::create($course_enquery);
        return back()->with('success','enquiry has been submitted successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CourseEnquery  $courseEnquery
     * @return \Illuminate\Http\Response
     */
    public function show(CourseEnquery $courseEnquery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CourseEnquery  $courseEnquery
     * @return \Illuminate\Http\Response
     */
    public function edit(CourseEnquery $courseEnquery)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CourseEnquery  $courseEnquery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CourseEnquery $courseEnquery)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CourseEnquery  $courseEnquery
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $course_enquery= CourseEnquery::where('id', $id)->update(array('delete_status' => 1));

        return back()->with('success','Enquiry has been deleted successfully');
    }
}
