<?php

namespace App\Http\Controllers\CustomeAuth;

use App\Models\User;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CustomeLoginController extends Controller
{

    public function index()
    {
        return view('backend.login');
    }

    public function adminLogin(Request $request)
    {
        $this->validate($request, [
            'email' => 'required',
            'password' => 'required',
        ]);
        $check_user_type = User::where('email', $request->email)->where('user_type', 'admin')->first();
        if($check_user_type != null){
            $credentials = $request->only('email', 'password');
            if (Auth::attempt($credentials)) {
                return redirect()->intended('/admin/dashboard')->with('success', 'You have Successfully logged in');
            }
        }

        return redirect()->route("adminLoginIndex")->with('error', 'Oppes!! You have entered invalid credentials');
    }

    public function adminLogout(){
        Session::flush();
        Auth::logout();

        return redirect()->route("adminLoginIndex")->with('success', 'You have Successfully logged out');
    }
}
