<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    public function index(){
        $faqs = Faq::where('delete_status','0')->latest()->get();
        return view('backend.faq.index', compact('faqs'));
    }

    public function store(Request $request){
        $faq = $request->all();
        Faq::create($faq);
        return back()->with('success','Faq added Successfully');
    }

    public function edit(Faq $faq){
        $faqs = Faq::where('delete_status','0')->latest()->get();
        return view('backend.faq.index', compact('faq','faqs'));
    }

    public function update(Request $request, $id){
        $faq = Faq::find($id);
        $input = $request->all();
        $faq->update($input);
        return redirect()->route('faq.index')->with('success','Faq updated Successfully');
    }

    public function destroy($id){
        $faq = Faq::where('id', $id)->update(array('delete_status' => 1));
        return redirect()->route('faq.index')->with('success','Faq deleted Successfully');
    }

    public function changeStatus(Request $request){
        $faq = Faq::find($request->id);
        $faq->status = $request->status;
        $faq->save();

        return response()->json(['success'=>'Status change successfully.']);
    }
}
