<?php

namespace App\Http\Controllers;

use App\Models\Testimonial;
use Illuminate\Http\Request;

class TestimonialController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $testimonials = Testimonial::orderBy('id','desc')->where('delete_status','0')->paginate(10);
        return view('backend/testimonial.index', compact('testimonials') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend/testimonial.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
        ]);

        $testimonial=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/testimonial'), $imageName);
            $testimonial['image']=$imageName;
        }


        $testimonial['slug']=\Str::slug($request->title).'-'.rand();
        Testimonial::create($testimonial);


        return redirect()->route('testimonial.index')
        ->with('success','testimonial created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function show(Testimonial $testimonial)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function edit(Testimonial $testimonial)
    {
        return view('backend/testimonial.edit',compact('testimonial'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $testimonial = Testimonial::find($id);
        $input=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/testimonial'), $imageName);
            $input['image']=$imageName;
        }

        $testimonial->update($input);


        return redirect()->route('testimonial.index')->with('success','Testimonial updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Testimonial  $testimonial
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $testimonial= Testimonial::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('testimonial.index')
                        ->with('success','Testimonial deleted successfully');
    }

    public function changeStatus(Request $request)

    {
        $testimonial = Testimonial::find($request->id);
        $testimonial->status = $request->status;
        $testimonial->save();

        return response()->json(['success'=>'Status change successfully.']);
    }
}
