<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoursesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->string('course_category_id')->nullable();
            $table->string('course_name')->nullable();
            $table->string('course_img')->nullable();
            $table->string('course_fees')->nullable();
            $table->string('course_fees_type')->nullable();
            $table->string('course_duration')->nullable();
            $table->text('course_eligibility')->nullable();
            $table->text('course_description')->nullable();
            $table->text('slug')->nullable();
            $table->integer('status')->default(1);
            $table->string('delete_status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('courses');
    }
}
