@extends('backend.layouts.app')
@section('content')

    <div class="content-page">
        <div class="content">
            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="{{ route('blog.create') }}" class="btn btn-sm btn-dark waves-effect">
                                        <i class="mdi mdi-plus me-1"></i> Add Blogs
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">All Blogs </h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->

                <div class="row">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-striped table-centered mb-0">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Short Description</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($blogs as $blog)

                                        <tr>
                                            <td class="table-user">
                                                <img id="blah" src="{{ URL::asset('backend/images/blog/' . $blog->image) }}" alt="your image"/>
                                            </td>
                                            <td>{{$blog->title}}</td>
                                            <td style="width:500px;">{{$blog->short_description}}</td>
                                            <td>
                                                <!-- Switch-->
                                                <div>
                                                    <input type="checkbox" data-id="{{$blog->id}}" id="switch_{{$blog->id}}" class="toggle-classs" value="{{$blog->id}}" {{ $blog->status ? 'checked' : '' }} data-switch="success" />
                                                    <label for="switch_{{$blog->id}}"  data-on-label="Yes" data-off-label="No"
                                                        class="mb-0 d-block"></label>
                                                </div>
                                            </td>
                                            <td class="table-action d-flex">

                                                <a href="{{ route('blog.edit',$blog->id) }}" class="action-icon"> <i
                                                        class="mdi mdi-pencil"></i></a>

                                                <form action="{{ route('blog.destroy', $blog->id) }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn text-danger btn-sm"
                                                        onclick="return areyousure();  " title="Delete"  class="action-icon">
                                                         <i class="mdi mdi-delete"
                                                            aria-hidden="true"></i> </button>
                                                </form>
                                            </td>
                                        </tr>


                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <!-- container -->

        </div>
        <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>


    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "{{route('blogstatus')}}",
                    data: {'status': status, 'id': id},
                    success: function(data){
                        {

                            $.NotificationApp.send("Success" ,data.success,"top-right", "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        });
      </script>

      @endsection

