@extends('backend.layouts.app')
@section('content')

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="#" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-reply me-1"></i> All Colleges
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Colleges</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                   <div class="col-md-7">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-striped table-centered mb-0">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($colleges as $data)

                                        <tr>
                                            <td class="table-user">
                                                <img id="blah" src="{{ URL::asset('backend/images/colleges/' . $data->image) }}"
                                                alt="your image" onerror="this.onerror=null; this.src='backend/images/no_image.svg'"/>
                                            </td>
                                            <td>{{$data->name}}</td>
                                            <td>{!!$data->description!!}</td>

                                            <td class="table-action d-flex">

                                                <a href="{{ route('college.edit',$data->id) }}" class="action-icon">
                                                     <i class="mdi mdi-pencil"></i></a>

                                                <form action="{{ route('college.destroy', $data->id) }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn text-danger btn-sm"
                                                        onclick="return areyousure();  " title="Delete"  class="action-icon">
                                                         <i class="mdi mdi-delete"
                                                            aria-hidden="true"></i> </button>
                                                </form>
                                            </td>
                                        </tr>


                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                   </div>
                <div class="col-md-5">
                    <div class="card">
                        <div class="card-body">
                            @if (isset($college) && isset($college->id))
                                <form action="{{ route('college.update', $college->id) }}" method="POST"
                                enctype="multipart/form-data" class="needs-validation" novalidate>
                                @method('PUT')
                            @else

                                <form action="{{ route('college.store') }}" method="POST"
                                enctype="multipart/form-data" class="needs-validation" novalidate>
                            @endif

                            @csrf


                           <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Course Name</label>
                                        <input type="text" class="form-control" name="name"
                                         @if(isset($college))value="{{ old('name', optional($college)->name) }}"@endif>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Description</label>
                                        <textarea class="ckeditor" class="form-control" name="description"> @if(isset($college)){{ old('description', optional($college)->description) }}@endif</textarea>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file"  name="image" class="form-control">
                                        @if(isset($college))<img id="blah" src="{{ URL::asset('backend/images/colleges/' . old('image', optional($college)->image))}}"
                                                onerror="this.onerror=null; this.src='../backend/images/no_image.png'" style="width: 35%;"/>@endif
                                    </div>

                                    <div class="mb-3 col-md-12">
                                       <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
              </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    @endsection
