@extends('backend.layouts.app')
@section('content')

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="#" class="btn btn-sm btn-dark waves-effect">
                                        <i class="mdi mdi-plus me-1"></i> All Course Enquerys
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">All Course Enquerys</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->

                <div class="row">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-striped table-centered mb-0">
                                <thead>
                                    <tr>
                                        <th>Course Name</th>
                                        <th>Name</th>
                                        <th>Number</th>
                                        <th>Email</th>
                                        <th>Subject</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($course_enquerys as $course_enquery)

                                        <tr>

                                            <td>{{$course_enquery->course_name}}</td>
                                            <td>{{$course_enquery->name}}</td>
                                            <td>{{$course_enquery->phone}}</td>
                                            <td>{{$course_enquery->email}}</td>
                                            <td>{{$course_enquery->subject}}</td>

                                            <td class="table-action">

                                                <form action="{{ route('course_enquiry.destroy', $course_enquery->id) }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn text-danger btn-sm"
                                                        onclick="return areyousure();  " title="Delete"  class="action-icon">
                                                         <i class="mdi mdi-delete"
                                                            aria-hidden="true"></i> </button>
                                                </form>
                                            </td>
                                        </tr>


                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <!-- container -->

        </div>
        <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "{{route('blogstatus')}}",
                    data: {'status': status, 'id': id},
                    success: function(data){
                        {

                            $.NotificationApp.send("Success" ,data.success,"top-right", "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        })
      </script>

@endsection

