<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title> Admin || {{env('APP_NAME')}}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
    <meta content="Coderthemes" name="author" />
    @php
        $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
    @endphp
    @isset($setup->favicon)
        <link rel="icon" type="image/png" href="{{ asset('backend/images/website/' . $setup->favicon) }}">
    @endisset

    <!-- third party css -->
    <link href="{{ asset('backend/css/vendor/jquery-jvectormap-1.2.2.css') }}" rel="stylesheet" type="text/css" />
    <!-- third party css end -->

    <!-- Editor css -->
    <link href="{{ asset('backend/css/vendor/quill.core.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('backend/css/vendor/quill.snow.css') }}" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('backend/css/app.min.css') }}" rel="stylesheet" type="text/css" id="app-style" />

    <link rel="apple-touch-icon" sizes="180x180" href="{{asset('frontend/images/favicon/apple-touch-icon.png')}}">
    <link rel="icon" type="image/png" href="{{asset('frontend/images/favicon/apple-touch-icon.png')}}" sizes="32x32">
    <link rel="icon" type="image/png" href="{{asset('frontend/images/favicon/apple-touch-icon.png')}}" sizes="16x16">
    <link rel="stylesheet" href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">


</head>


<body class="loading" data-layout-color="light" data-leftbar-theme="dark" data-layout-mode="fluid"
data-rightbar-onstart="true">
        @include('backend.layouts.sidebar')
        @include('backend.layouts.header')
           @yield('content')
        @include('backend.layouts.footer')
@yield('script')
    </body>

</html>
