@php
    $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
@endphp
<div class="wrapper">
    <div class="leftside-menu">

        <!-- LOGO -->
        <a href="/admin/dashboard" class="logo text-center logo-light">
            @if ($setup && $setup->logo)
                <span class="logo-lg">
                    <img src="{{ asset('backend/images/website/' . $setup->logo) }}"
                        onerror="this.src='{{ asset('backend/images/no_image.png') }}'; this.onerror='';" alt=""
                        style="width: 160px; height: 50px;">
                </span>
            @endif
            <span class="logo-sm">
                <img src="{{ asset('frontend/img/favicon.png') }}" alt="" height="30">
            </span>
        </a>

        <div class="h-100 pt-2" id="leftside-menu-container" data-simplebar>

            <!--- Sidemenu -->
            <ul class="side-nav">

                <li class="side-nav-item">
                    <a href="/admin/dashboard"
                        class="side-nav-link {{ request()->is('admin/dashboard') ? 'active' : '' }}">
                        <i class="uil-home-alt"></i>
                        <span> Dashboards </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('service.index') }}"
                        class="side-nav-link {{ request()->routeIs('service.index') ? 'active' : '' }}">
                        <i class="uil-sitemap"></i>
                        <span> Services </span>
                    </a>
                </li>

                {{-- <li class="side-nav-item">
                    <a href="{{ route('product.index') }}"
                        class="side-nav-link {{ request()->routeIs('product.index') ? 'active' : '' }}">
                        <i class="uil-bolt"></i>
                        <span> Product </span>
                    </a>
                </li> --}}

                <li class="side-nav-item">
                    <a href="{{ route('aboutpage.index') }}" class="side-nav-link">
                        <i class="uil-copy-alt"></i>
                        <span> About Page </span>
                    </a>
                </li>


                {{-- <li class="side-nav-item">
                    <a data-bs-toggle="collapse" href="#courses" aria-expanded="false" aria-controls="courses"
                        class="side-nav-link">
                        <i class="uil-copy-alt"></i>
                        <span> Services </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="courses">
                        <ul class="side-nav-second-level">
                            <li>
                                <a href="{{ route('service-category.index') }}">Category</a>
                            </li>
                            <li>
                                <a href="{{ route('service.index') }}">All Services</a>
                            </li>
                        </ul>
                    </div>
                </li> --}}

                {{-- <li class="side-nav-item">
                    <a href="{{ route('courses.index') }}" class="side-nav-link">
                        <i class="uil-copy-alt"></i>
                        <span> All Courses </span>
                    </a>
                </li> --}}

                {{-- <li class="side-nav-item">
                    <a href="{{ route('faq.index') }}"
                        class="side-nav-link {{ request()->routeIs('faq.index') ? 'active' : '' }}">
                        <i class="uil uil-question-circle"></i>
                        <span> Faqs </span>
                    </a>
                </li> --}}

                <li class="side-nav-item">
                    <a href="{{ route('slider.index') }}"
                        class="side-nav-link {{ request()->routeIs('slider.index') ? 'active' : '' }}">
                        <i class="uil uil-image"></i>
                        <span> Sliders </span>
                    </a>
                </li>

                {{-- <li class="side-nav-item">
                    <a href="{{ route('gallery.index') }}" class="side-nav-link">
                        <i class="uil uil-images"></i>
                        <span> Gallery </span>
                    </a>
                </li> --}}

                {{-- <li class="side-nav-item">
                        <a href="{{ route('registration-view') }}" class="side-nav-link">
                            <i class="uil uil-comment-alt-lines"></i>
                            <span> Registration Form  </span>
                        </a>
                    </li> --}}

                <li class="side-nav-item">
                    <a href="{{ route('blog.index') }}"
                        class="side-nav-link {{ request()->routeIs('blog.index') ? 'active' : '' }}">
                        <i class="dripicons-blog"></i>
                        <span> Blogs </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('newsroom.index') }}"
                        class="side-nav-link {{ request()->routeIs('newsroom.index') ? 'active' : '' }}">
                        <i class="dripicons-blog"></i>
                        <span> News Room </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('career.index') }}"
                        class="side-nav-link {{ request()->routeIs('career.index') ? 'active' : '' }}">
                        <i class="uil-briefcase-alt"></i>
                        <span> Career </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('client.index') }}"
                        class="side-nav-link {{ request()->routeIs('client.index') ? 'active' : '' }}">
                        <i class="uil-chat-bubble-user"></i>
                        <span> Client </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('team.index') }}"
                        class="side-nav-link {{ request()->routeIs('team.index') ? 'active' : '' }}">
                        <i class="uil-users-alt"></i>
                        <span> Team </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('testimonial.index') }}"
                        class="side-nav-link {{ request()->routeIs('testimonial.index') ? 'active' : '' }}">
                        <i class="uil-comment"></i>
                        <span> Testimonials </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('enquiry.index') }}"
                        class="side-nav-link {{ request()->routeIs('enquiry.index') ? 'active' : '' }}">
                        <i class="uil-comment-question"></i>
                        <span> Enquiry </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('terms.index') }}" class="side-nav-link">
                        <i class="mdi mdi-security"></i>
                        <span> Terms & Privacy </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="{{ route('website.index') }}" class="side-nav-link class="side-nav-link
                        {{ request()->routeIs('website.index') ? 'active' : '' }}">
                        <i class="uil-cog"></i>
                        <span> Website Setup </span>
                    </a>
                </li>

            </ul>
            <!-- End Sidebar -->

            <div class="clearfix"></div>

        </div>
        <!-- Sidebar -left -->

    </div>
