@extends('backend.layouts.app')
@section('content')

    <div class="content-page">
        <div class="content">
            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="{{ route('newsroom.create') }}" class="btn btn-sm btn-dark waves-effect">
                                        <i class="mdi mdi-plus me-1"></i> Add News Room
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">All News Room </h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->

                <div class="row">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-striped table-centered mb-0">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Short Description</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($newsrooms as $newsroom)

                                        <tr>
                                            <td class="table-user">
                                                <img id="blah" src="{{ URL::asset('backend/images/newsroom/' . $newsroom->image) }}" alt="your image"/>
                                            </td>
                                            <td>{{$newsroom->title}}</td>
                                            <td style="width:500px;">{{$newsroom->short_description}}</td>
                                            <td>
                                                <!-- Switch-->
                                                <div>
                                                    <input type="checkbox" data-id="{{$newsroom->id}}" id="switch_{{$newsroom->id}}" class="toggle-classs" value="{{$newsroom->id}}" {{ $newsroom->status ? 'checked' : '' }} data-switch="success" />
                                                    <label for="switch_{{$newsroom->id}}"  data-on-label="Yes" data-off-label="No"
                                                        class="mb-0 d-block"></label>
                                                </div>
                                            </td>
                                            <td class="table-action d-flex">

                                                <a href="{{ route('newsroom.edit',$newsroom->id) }}" class="action-icon"> <i
                                                        class="mdi mdi-pencil"></i></a>

                                                <form action="{{ route('newsroom.destroy', $newsroom->id) }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn text-danger btn-sm"
                                                        onclick="return areyousure();  " title="Delete"  class="action-icon">
                                                         <i class="mdi mdi-delete"
                                                            aria-hidden="true"></i> </button>
                                                </form>
                                            </td>
                                        </tr>


                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <!-- container -->

        </div>
        <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>


    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "{{route('newsroomstatus')}}",
                    data: {'status': status, 'id': id},
                    success: function(data){
                        {

                            $.NotificationApp.send("Success" ,data.success,"top-right", "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        });
      </script>

      @endsection

