@extends('backend.layouts.app')
@section('content')
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="{{ route('service.create') }}" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-plus me-1"></i> Add Services
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Services</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped table-centered mb-0">
                                    <thead>
                                        <tr>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($servicespage as $data)
                                            <tr>
                                                <td class="table-user">
                                                    <img id="blah"
                                                        src="{{ URL::asset('backend/images/services/' . $data->image) }}"
                                                        alt="your image"
                                                        onerror="this.onerror=null; this.src='{{ asset('backend/images/no_image.svg') }}'" />
                                                </td>
                                                <td>{{ $data->title }}</td>
                                                <td>
                                                    <!-- Switch-->
                                                    <div>
                                                        <input type="checkbox" data-id="{{ $data->id }}"
                                                            id="switch_{{ $data->id }}" class="toggle-classs"
                                                            value="{{ $data->id }}" {{ $data->status ? 'checked' : '' }}
                                                            data-switch="success" />
                                                        <label for="switch_{{ $data->id }}" data-on-label="Yes"
                                                            data-off-label="No" class="mb-0 d-block"></label>
                                                    </div>
                                                </td>
                                                <td class="table-action d-flex">

                                                    <a href="{{ route('service.edit', $data->id) }}" class="action-icon">
                                                        <i class="mdi mdi-pencil"></i></a>

                                                    <form action="{{ route('service.destroy', $data->id) }}" method="POST">
                                                        @method('DELETE')
                                                        @csrf
                                                        <button class="btn text-danger btn-sm"
                                                            onclick="return areyousure();  " title="Delete"
                                                            class="action-icon">
                                                            <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="card">
                            <div class="card-body">
                                @if (isset($edit_service) && isset($edit_service->id))
                                    <form action="{{ route('service.update', $edit_service->id) }}" method="POST"
                                        enctype="multipart/form-data" class="needs-validation" novalidate>
                                        @method('PUT')
                                    @else
                                        <form action="{{ route('service.store') }}" method="POST"
                                            enctype="multipart/form-data" class="needs-validation" novalidate>
                                @endif
                                @csrf

                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Title</label>
                                        <input type="text" class="form-control" name="title" required
                                            @if (isset($edit_service)) value="{{ old('title', optional($edit_service)->title) }}" @endif>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Website Link</label>
                                        <input type="text" class="form-control" name="link"
                                            @if (isset($edit_service)) value="{{ old('link', optional($edit_service)->link) }}" @endif>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file" id="image" name="image" class="form-control">
                                        @if (isset($edit_service))
                                            <img id="img"
                                                src="{{ URL::asset('backend/images/services/' . old('image', optional($edit_service)->image)) }}"
                                                onerror="this.onerror=null; this.src='{{ asset('backend/images/no_image.png') }}'"
                                                style="width: 35%;" />
                                        @else
                                            <img class="mt-2" id="img"
                                                src="{{ asset('backend/images/no_image.png') }}"
                                                onerror="this.onerror=null;this.src='{{ asset('backend/images/no_image.png') }}'"
                                                height="100px" width="100px">
                                        @endif
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Description</label>
                                        <textarea class="ckeditor" name="description"
                                            @if (isset($servicespage)) value="{{ old('description') }}" @endif>
                                            @isset($edit_service)
                                            {!! $edit_service->description !!}
                                            @endisset
                                        </textarea>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        image.onchange = evt => {
            const [file] = image.files
            if (file) {
                img.src = URL.createObjectURL(file)
            }
        }
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "{{ route('servicestatus') }}",
                    data: {
                        'status': status,
                        'id': id
                    },
                    success: function(data) {
                        {

                            $.NotificationApp.send("Success", data.success, "top-right",
                                "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        });
    </script>
@endsection
