@php
    $setup = App\Models\WebsiteSetup::where('delete_status', '0')->first();
    $services = App\Models\Services::where('delete_status', '0')->where('status', '1')->get();
@endphp

<!-- header start -->
<header id="masthead" class="header prt-header-style-01">
    <!-- topbar -->
    <div class="top_bar prt-topbar-wrapper text-base-white clearfix">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="d-flex flex-row align-items-start justify-content-start">
                        <div class="top_bar_contact_item mob-d-none">
                            <span class="text-base-skin"></span><a
                                href="tel:+91-{{ $setup ? $setup->contact_phone_1 : '' }}"><i
                                    class="flaticon-phone-call"></i>&nbsp;
                                +91-{{ $setup ? $setup->contact_phone_1 : '' }}</a>,
                                <a
                                href="tel:+91-{{ $setup ? $setup->contact_phone_2 : '' }}">
                                +91-{{ $setup ? $setup->contact_phone_2 : '' }}</a>
                        </div>
                        <div class="top_bar_contact_item mob-d-none">
                            <span class="text-base-skin"></span><a
                                href="mailto:{{ $setup ? $setup->contact_email_1 : '' }}"><i
                                    class="flaticon-email"></i>&nbsp; {{ $setup ? $setup->contact_email_1 : '' }}</a>
                        </div>
                        <div class="top_bar_contact_item top_bar_social ms-auto">
                            <ul class="social-icons">
                                <li class="prt-social-instagram"><a href="{{ $setup ? $setup->instagram_link : '' }}"
                                        target="_blank" aria-label="instagram"><i class="icon-instagram"></i></a></li>
                                <li class="prt-social-facebook"><a href="{{ $setup ? $setup->facebook_link : '' }}"
                                        target="_blank" aria-label="facebook"><i class="icon-facebook"></i></a></li>
                                <li class="prt-social-twitter"><a href="{{ $setup ? $setup->twitter_link : '' }}"
                                        target="_blank" aria-label="twitter"><i class="icon-twitter"></i></a></li>
                                <li class="prt-social-linkedin"><a href="{{ $setup ? $setup->linkedin_link : '' }}"
                                        target="_blank" aria-label="linkedin"><i class="icon-linkedin"></i></a></li>
                                <li class="prt-social-youtube"><a href="{{ $setup ? $setup->youtube_link : '' }}"
                                        target="_blank" aria-label="linkedin"><i class="icon-youtube"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- topbar end -->
    <!-- site-header-menu -->
    <div id="site-header-menu" class="site-header-menu">
        <div class="site-header-menu-inner prt-stickable-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <!--site-navigation -->
                        <div class="site-navigation d-flex align-items-center justify-content-between">
                            <!-- site-branding -->
                            <div class="site-branding me-auto">
                                <h1>
                                    <a class="home-link" href="/">
                                        <img src="{{ $setup ? asset('backend/images/website/' . $setup->header_logo) : '' }}"
                                            width="220"
                                            onerror="this.src='{{ asset('frontend/images/logo.png') }}';this.onerror='';">
                                    </a>
                                </h1>
                            </div><!-- site-branding end -->
                            <div class="btn-show-menu-mobile menubar menubar--squeeze">
                                <span class="menubar-box">
                                    <span class="menubar-inner"></span>
                                </span>
                            </div>
                            <!-- menu -->
                            <nav class="main-menu menu-mobile" id="menu">
                                <ul class="menu">
                                    <li class="mega-menu-item  @if (Route::currentRouteName() == 'home') active @endif">
                                        <a href="/">Home</a>
                                    </li>

                                    <li class="mega-menu-item @if (Route::currentRouteName() == 'about' || Route::currentRouteName() == 'team') active @endif">
                                        <a href="#" class="mega-menu-link">About Us</a>
                                        <ul class="mega-submenu">
                                            <li><a href="{{ route('about') }}">About TPL Groups</a></li>
                                            <li><a href="{{ route('team') }}">Director Messages</a></li>
                                        </ul>
                                    </li>

                                    <li class="mega-menu-item @if (Route::currentRouteName() == 'service-detail') active @endif">
                                        <a href="#" class="mega-menu-link">Business</a>
                                        <ul class="mega-submenu">
                                            @foreach ($services as $service)
                                                <li><a href="{{ route('service-detail', $service->slug) }}">{{ $service->title }}</a></li>
                                            @endforeach
                                        </ul>
                                    </li>

                                    <li>
                                        <a href="#">Companies</a>
                                    </li>

                                    {{-- <li class="mega-menu-item @if (Route::currentRouteName() == 'registration')@endif">
                                                <a href="#" class="mega-menu-link">Certificates</a>
                                                <ul class="mega-submenu">
                                                    <li><a href="{{route('registration','udyam-registration')}}">Udyam Registration</a></li>
                                                    <li><a href="{{route('registration','import-export-code')}}">Import Export Code </a></li>
                                                    <li><a href="{{route('registration','fassi-registration')}}">FASSI Registration </a></li>
                                                    <li><a href="{{route('registration','tan')}}">TAN </a></li>
                                                    <li><a href="{{route('registration','pf-registration')}}">PF Registration </a></li>
                                                    <li><a href="{{route('registration','esi-registration')}}">ESI Registration </a></li>
                                                    <li><a href="{{route('registration','isds')}}">ISDS</a></li>
                                                    <li class="mega-menu-item">
                                                        <a href="#" class="mega-menu-link">Documents</a>
                                                        <ul class="mega-submenu">
                                                            <li><a href="{{route('registration','rent-agreement')}}">Rent Agreement</a></li>
                                                            <li><a href="{{route('registration','nocs')}}">NOCs</a></li>
                                                            <li><a href="{{route('registration','high-sea-sales-agreements')}}">High Sea Sales Agreements</a></li>
                                                            <li><a href="{{route('registration','other-legal-draftings')}}">Other Legal Draftings</a></li>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </li> --}}

                                    <li class="mega-menu-item @if (Route::currentRouteName() == 'blog' || Route::currentRouteName() == 'blogs') active @endif">
                                        <a href="{{ route('blog') }}">Blogs</a>
                                    </li>

                                    <li>
                                        <a href="#">Investors</a>
                                    </li>

                                    <li class="mega-menu-item @if (Route::currentRouteName() == 'newsroom' || Route::currentRouteName() == 'newsrooms') active @endif">
                                        <a href="{{ route('newsroom') }}">News Room</a>
                                    </li>

                                    <li>
                                        <a href="#">Careers</a>
                                    </li>

                                    <li class="mega-menu-item  @if (Route::currentRouteName() == 'contact') active @endif">
                                        <a href="{{ route('contact') }}">Contact Us</a>
                                    </li>
                                </ul>
                            </nav><!-- menu end -->
                            <!-- header_extra -->
                            <div class="header_extra d-flex flex-row align-items-center justify-content-end">
                                <div class="header_btn">
                                    <a class="prt-btn prt-btn-size-sm prt-btn-shape-rounded prt-btn-style-fill prt-btn-color-dark"
                                        href="#">Book Now </a>
                                </div>
                            </div>
                            <!-- header_extra end -->
                        </div><!-- site-navigation end-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- site-header-menu end-->
</header>
<!-- header end -->
