<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\AboutController;
use App\Http\Controllers\TermsController;
use App\Http\Controllers\CareerController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\CollegeController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\HomePageController;
use App\Http\Controllers\NewsroomController;
use App\Http\Controllers\ServicesController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\WebsiteSetupController;
use App\Http\Controllers\CourseEnqueryController;
use App\Http\Controllers\CourseCategoryController;
use App\Http\Controllers\CustomeAuth\CustomeLoginController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', [CustomeLoginController::class, 'index'])->name('adminLoginIndex');

Route::post('admin-login', [CustomeLoginController::class, 'adminLogin'])->name('adminLogin');

Route::group(['middleware' => ['admin']], function(){

    Route::get('/dashboard', function() {
        return view('backend.dashboard');
    });

    // Route::get('/blog', function() {
    //     return view('backend.blog.create');
    // });

    Route::resource('slider', SliderController::class);
    Route::get('sliderstatus', [SliderController::class, 'changeStatus'])->name('sliderstatus');

    Route::resource('homepage', HomePageController::class);

    Route::resource('aboutpage', AboutController::class);

    Route::resource('client', ClientController::class);
    Route::get('clientstatus', [ClientController::class, 'changeStatus'])->name('clientstatus');

    Route::resource('team', TeamController::class);
    Route::get('teamstatus', [TeamController::class, 'changeStatus'])->name('teamstatus');

    Route::resource('faq', FaqController::class);
    Route::get('faqstatus', [FaqController::class, 'changeStatus'])->name('faqstatus');

    Route::resource('service', ServicesController::class);
    Route::get('servicestatus', [ServicesController::class, 'changeStatus'])->name('servicestatus');

    Route::resource('product', ProductController::class);
    Route::get('productstatus', [ProductController::class, 'changeStatus'])->name('productstatus');

    Route::resource('site', SiteController::class);
    Route::get('sitestatus', [SiteController::class, 'changeStatus'])->name('sitestatus');

    Route::resource('career', CareerController::class);

    Route::resource('service-category', CourseCategoryController::class);

    Route::resource('college', CollegeController::class);

    Route::resource('gallery', GalleryController::class);

    Route::resource('blog', BlogController::class);
    Route::get('blogstatus', [BlogController::class, 'changeStatus'])->name('blogstatus');

    Route::resource('newsroom', NewsroomController::class);
    Route::get('newsroomstatus', [NewsroomController::class, 'changeStatus'])->name('newsroomstatus');

    Route::resource('testimonial', TestimonialController::class);
    Route::get('testimonialstatus', [TestimonialController::class, 'changeStatus'])->name('testimonialstatus');

    Route::resource('terms', TermsController::class);

    Route::resource('website', WebsiteSetupController::class);

    Route::resource('enquiry', EnquiryController::class);

    Route::get('registration_forms', [EnquiryController::class, 'registrationForm'])->name('registration_forms');

    Route::get('adminLogout', [CustomeLoginController::class, 'adminLogout'])->name('adminLogout');
});


//Auth::routes();
