<?php $__env->startSection('content'); ?>
    <div class="search-overlay">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-close">
                    <span class="search-close-line"></span>
                    <span class="search-close-line"></span>
                </div>
                <div class="search-form">
                    <form>
                        <input type="text" class="input-search" placeholder="Search here...">
                        <button type="submit"><i class="bx bx-search"></i></button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="inner-banner" id="banner-opc">
        <div class="container">
            <div class="inner-title text-center">
                <h3>Career</h3>
                <ul>
                    <li>
                        <a href="<?php echo e(route('home')); ?>">Home</a>
                    </li>
                    <li>
                        <i class="bx bx-chevrons-right"></i>
                    </li>
                    <li>Career</li>
                </ul>
            </div>
        </div>
        <div class="inner-shape">
            <img src="<?php echo e(asset('frontend/images/shape/inner-shape.png')); ?>" alt="Images">
        </div>
    </div>


    <div class="contact-form-area pt-70">
        <div class="container">
            <div class="section-title text-center">
                <span class="sp-color2">Join Our Team</span>
                <h2>Life at ARMS</h2>
                <p class="margin-auto">
                    Either way, we’d love to hear from you. We’re always on the lookout for new talent to add to our global
                    team. And with offices around the world and teams across the globe, we have the right opportunities for
                    the right people.
                </p>
            </div>
            <div class="row pt-45">
                <div class="col-lg-12">
                    <div class="contact-form">
                        <form action="<?php echo e(route('careerform')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <?php if($message = Session::get('success')): ?>
                                <div class="alert alert-success" id="success-message">
                                    <p><?php echo e($message); ?></p>
                                </div>
                                <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                                <script>
                                    $(document).ready(function() {
                                        setTimeout(function() {
                                            $('#success-message').fadeOut('slow');
                                        }, 3000);
                                    });
                                </script>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Complete Name <span>*</span></label>
                                        <input type="text" name="name" id="name" class="form-control" required
                                            value="<?php echo e(old('name')); ?>" data-error="Please Enter Your Complete Name"
                                            placeholder="Name">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Email Address <span>*</span></label>
                                        <input type="email" name="email" id="email" class="form-control" required
                                            value="<?php echo e(old('email')); ?>" data-error="Please Enter Your Email Address"
                                            placeholder="Email">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Contact Number <span>*</span></label>
                                        <input type="text" name="number" id="phone_number" required
                                            value="<?php echo e(old('number')); ?>" data-error="Please Enter Your Contact Number"
                                            class="form-control" placeholder="Phone Number" oninput="validatePhone(this)">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Education Qualification <span>*</span></label>
                                        <input type="text" name="qualification" id="qualification" class="form-control"
                                            value="<?php echo e(old('qualification')); ?>" required data-error="Please Enter Your Qualification"
                                            placeholder="Your Qualification">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group">
                                        <label>Complete Address <span>*</span></label>
                                        <textarea name="address" class="form-control" id="address" cols="30" rows="4" required
                                            data-error="Write Your Address" placeholder="Your Address"><?php echo e(old('message')); ?></textarea>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12">
                                    <div class="form-group">
                                        <label>Message to the Hiring Team <span>*</span></label>
                                        <textarea name="message" class="form-control" id="message" cols="30" rows="8" required
                                            data-error="Write Your Message" placeholder="Your Message"><?php echo e(old('message')); ?></textarea>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 text-center">
                                    <button type="submit" class="default-btn btn-bg-two border-radius-50">
                                        Send Message <i class="bx bx-chevron-right"></i>
                                    </button>
                                    <div id="msgSubmit" class="h3 text-center hidden"></div>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="team-area ptb-70">
        <div class="container">
            <div class="section-title text-center">
                <span class="sp-color2">Our Team</span>
                <h2>Our Team Members</h2>
            </div>
            <div class="case-study-slider owl-carousel owl-theme pt-45">
                <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col">
                        <div class="team-card">
                            <img src="<?php echo e(asset('backend/images/team/' . $team->image)); ?>" alt="Team Images">
                            <div class="content">
                                <h3><?php echo e($team->name); ?></h3>
                                <span><?php echo e($team->designation); ?></span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\analysis_service\resources\views/frontend/career.blade.php ENDPATH**/ ?>