<?php $__env->startSection('content'); ?>
    <main class="main">

        <!-- Carousel -->
        <div id="demo" class="carousel slide" data-bs-ride="carousel">

            <!-- Indicators/dots -->
            <div class="carousel-indicators">
                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo e($index); ?>"
                        class="<?php echo e($index == 0 ? 'active' : ''); ?>"></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- The slideshow/carousel -->
            <div class="carousel-inner">
                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                        <img src="<?php echo e(asset('backend/images/slider/' . $slider->image)); ?>" alt="Slide <?php echo e($index + 1); ?>"
                            class="d-block" style="width:100%">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Left and right controls/icons -->
            <button class="carousel-control-prev" type="button" data-bs-target="#demo" data-bs-slide="prev">
                <div class="carousel-dir">
                    <span class="carousel-control-prev-icon"></span>
                </div>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#demo" data-bs-slide="next">
                <div class="carousel-dir">
                    <span class="carousel-control-next-icon"></span>
                </div>
            </button>
        </div>

        <!-- about area -->
        <div class="about-area pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="about-left wow fadeInLeft" data-wow-delay=".25s">
                            <div class="about-img">
                                <div class="row">
                                    <div class="col-6">
                                        <img class="img-1" src="<?php echo e(asset('frontend/img/about/01.jpg')); ?>" alt="">
                                    </div>
                                    <div class="col-6">
                                        <img class="img-2" src="<?php echo e(asset('frontend/img/about/02.jpg')); ?>" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="about-experience">
                                <h5>29<sup>+</sup></h5>
                                <p>Years Of Experience</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about-right wow fadeInUp" data-wow-delay=".25s">
                            <div class="site-heading mb-3">
                                <span class="site-title-tagline"><i class="far fa-solar-panel"></i> About Us</span>
                                <h2 class="site-title">Welcome to <span><?php echo e(env('APP_NAME')); ?></span>
                                </h2>
                                <div class="heading-divider"></div>
                            </div>
                            <p class="about-text">At <?php echo e(env('APP_NAME')); ?>, we are dedicated to powering a
                                sustainable future through innovative and reliable solar energy solutions. With 29 years of
                                expertise in both the automotive and renewable energy sectors, we bridge the gap between
                                cutting-edge technology and environmental responsibility.</p>
                            <div class="about-content">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="about-item">
                                            <div class="icon">
                                                <img src="<?php echo e(asset('frontend/img/icon/install.svg')); ?>" alt="">
                                            </div>
                                            <div class="content">
                                                <h6>Expertise</h6>
                                                <p>Decades of experience in the solar energy industry</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="about-item">
                                            <div class="icon">
                                                <img src="<?php echo e(asset('frontend/img/icon/material.svg')); ?>" alt="">
                                            </div>
                                            <div class="content">
                                                <h6>Quality Material</h6>
                                                <p>Premium solar products and reliable systems</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <a href="about.html" class="theme-btn">Discover More<i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- about area end -->


        <!-- feature area -->
        <div class="feature-area pb-80">
            <div class="container">
                <div class="feature-wrap">
                    <div class="row g-4">
                        <div class="col-md-6 col-lg-4">
                            <div class="feature-item one">
                                <span class="count">01</span>
                                <div class="feature-icon">
                                    <img src="<?php echo e(asset('frontend/img/icon/staff.svg')); ?>" alt="">
                                </div>
                                <div class="feature-content">
                                    <h4>Experts Staff</h4>
                                    <p>It is a long established fact that a reader will be distract by the page readable
                                        content when are the looking
                                        at its using layout.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-4">
                            <div class="feature-item two">
                                <span class="count">02</span>
                                <div class="feature-icon">
                                    <img src="<?php echo e(asset('frontend/img/icon/money.svg')); ?>" alt="">
                                </div>
                                <div class="feature-content">
                                    <h4>Affordable Pricing</h4>
                                    <p>It is a long established fact that a reader will be distract by the page readable
                                        content when are the looking
                                        at its using layout.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-4">
                            <div class="feature-item three">
                                <span class="count">03</span>
                                <div class="feature-icon">
                                    <img src="<?php echo e(asset('frontend/img/icon/support.svg')); ?>" alt="">
                                </div>
                                <div class="feature-content">
                                    <h4>24/7 Support</h4>
                                    <p>It is a long established fact that a reader will be distract by the page readable
                                        content when are the looking
                                        at its using layout.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- feature area end -->


        <!-- service area -->
        <div class="service-area sa-bg pt-50 pb-50">
            <div class="container mb-20">
                <div class="row">
                    <div class="col-lg-6 mx-auto">
                        <div class="site-heading text-center">
                            <span class="site-title-tagline"><i class="far fa-solar-panel"></i> Our Services</span>
                            <h2 class="site-title">Let's check our <span>services</span></h2>
                            <div class="heading-divider"></div>
                        </div>
                    </div>
                </div>
                <div class="row g-4">
                    <div class="col-lg-12">
                        <div class="service-slider owl-carousel">
                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="service-item">
                                    <div class="service-img">
                                        <img src="<?php echo e(asset('backend/images/services/' . $service->image)); ?>"
                                            alt="">
                                    </div>
                                    <div class="service-content">
                                        <h4 class="service-title">
                                            <?php echo e($service->title); ?>

                                        </h4>
                                        <p class="service-text">
                                            <?php echo $service->description; ?>

                                        </p>
                                        
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- service area end -->


        <!-- product area -->
        <div class="shop-item-wrap pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 mx-auto">
                        <div class="site-heading text-center">
                            <span class="site-title-tagline"><i class="far fa-solar-panel"></i> Our Product</span>
                            <h2 class="site-title">Let's check our <span>Products</span></h2>
                            <div class="heading-divider"></div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3 col-6">
                            <div class="shop-item">
                                <div class="shop-item-img">
                                    <img src="<?php echo e(asset('backend/images/product/' . $product->image)); ?>"
                                        onerror="this.onerror=null; this.src='frontend/img/Image-not-found.png'"
                                        alt="">
                                </div>
                                <div class="shop-item-info">
                                    <div class="shop-item-rate">
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                    </div>
                                    <a href="#">
                                        <h4 class="shop-item-title"><?php echo e($product->title); ?></h4>
                                    </a>
                                    
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <!-- product area end -->


        <!-- counter area -->
        <div class="counter-area pt-40 pb-40">
            <div class="container">
                <div class="row g-4 justify-content-center">
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <div class="counter-box wow fadeInUp" data-wow-delay=".25s">
                            <div class="icon">
                                <img src="<?php echo e(asset('frontend/img/icon/solar.svg')); ?>" alt="">
                            </div>
                            <div class="content">
                                <div class="info">
                                    <span class="counter" data-count="+" data-to="150" data-speed="3000">150</span>
                                    <sup class="unit">+</sup>
                                </div>
                                <h6 class="title">Projects Done</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <div class="counter-box wow fadeInDown" data-wow-delay=".25s">
                            <div class="icon">
                                <img src="<?php echo e(asset('frontend/img/icon/rating.svg')); ?>" alt="">
                            </div>
                            <div class="content">
                                <div class="info">
                                    <span class="counter" data-count="+" data-to="120" data-speed="3000">120</span>
                                    <sup class="unit">+</sup>
                                </div>
                                <h6 class="title">Happy Clients</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <div class="counter-box wow fadeInUp" data-wow-delay=".25s">
                            <div class="icon">
                                <img src="<?php echo e(asset('frontend/img/icon/staff.svg')); ?>" alt="">
                            </div>
                            <div class="content">
                                <div class="info">
                                    <span class="counter" data-count="+" data-to="20" data-speed="3000">20</span>
                                    <sup class="unit">+</sup>
                                </div>
                                <h6 class="title">Experts Staff</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <div class="counter-box wow fadeInDown" data-wow-delay=".25s">
                            <div class="icon">
                                <img src="<?php echo e(asset('frontend/img/icon/award.svg')); ?>" alt="">
                            </div>
                            <div class="content">
                                <div class="info">
                                    <span class="counter" data-count="+" data-to="50" data-speed="3000">50</span>
                                    <sup class="unit">+</sup>
                                </div>
                                <h6 class="title">Win Awards</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- counter area end -->

        <!-- choose area -->
        <div class="choose-area py-80">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="choose-content wow fadeInUp" data-wow-delay=".25s">
                            <div class="site-heading mb-0">
                                <span class="site-title-tagline"><i class="fas fa-solar-panel"></i> Why Choose Us</span>
                                <h2 class="site-title">Why Choose <span><?php echo e(env('APP_NAME')); ?></span> for Your Solar Energy
                                    Needs</h2>
                                <div class="heading-divider"></div>
                                <p>
                                    At <?php echo e(env('APP_NAME')); ?>, we are dedicated to providing reliable, innovative, and
                                    cost-effective solar energy solutions to meet your unique needs. Here’s why we stand out
                                    in the solar industry:
                                </p>
                            </div>
                            <div class="choose-content-wrap">
                                <div class="choose-item">
                                    <div class="choose-item-icon">
                                        <img src="<?php echo e(asset('frontend/img/icon/money-2.svg')); ?>" alt="">
                                    </div>
                                    <div class="choose-item-info">
                                        <h4>Affordable and Transparent Pricing</h4>
                                        <p>We believe in fair and transparent pricing. At Auto Enterprises, you’ll receive a
                                            clear breakdown of costs upfront with no hidden fees, so you can make informed
                                            decisions.</p>
                                    </div>
                                </div>
                                <div class="choose-item">
                                    <div class="choose-item-icon">
                                        <img src="<?php echo e(asset('frontend/img/icon/staff.svg')); ?>" alt="">
                                    </div>
                                    <div class="choose-item-info">
                                        <h4>Expertise and Experience</h4>
                                        <p>With 29 years of industry experience, our team of professionals has the knowledge
                                            and skills to design and install the perfect solar system for your home or
                                            business. </p>
                                    </div>
                                </div>
                                <div class="choose-item">
                                    <div class="choose-item-icon">
                                        <img src="<?php echo e(asset('frontend/img/icon/certified.svg')); ?>" alt="">
                                    </div>
                                    <div class="choose-item-info">
                                        <h4>Proven Track Record</h4>
                                        <p>Our satisfied customers are a testament to our commitment to excellence. We have
                                            successfully completed hundreds of solar projects, earning trust and recognition
                                            in the industry.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="choose-img wow fadeInRight" data-wow-delay=".25s">
                            <img class="img-1" src="<?php echo e(asset('frontend/img/choose/01.jpg')); ?>" alt="">
                            <img class="img-2" src="<?php echo e(asset('frontend/img/choose/02.jpg')); ?>" alt="">
                            <img class="shape" src="<?php echo e(asset('frontend/img/shape/06.png')); ?>" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- choose area end -->

        <!-- testimonial-area -->
        <div class="testimonial-area2 tm-bg pt-80 pb-60">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="site-heading wow fadeInDown" data-wow-delay=".25s">
                            <span class="site-title-tagline"><i class="fas fa-solar-panel"></i> Testimonials</span>
                            <h2 class="site-title">What Our Client <span>Say's</span> about us</h2>
                            <div class="heading-divider"></div>
                            <p>
                                See how solar power is making a difference for homeowners, businesses, and the environment.
                                Hear from our satisfied customers who are already enjoying the benefits.
                            </p>
                            <a href="<?php echo e(route('contact')); ?>" class="theme-btn mt-30">Know More <i
                                    class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-8">
                        <div class="testimonial-slider owl-carousel owl-theme wow fadeInUp" data-wow-delay=".25s">
                            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="testimonial-item">
                                    <div class="testimonial-quote">
                                        <div class="testimonial-rate">
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                        </div>
                                        <div class="testimonial-quote-icon">
                                            <img src="<?php echo e(asset('frontend/img/icon/quote.svg')); ?>" alt="">
                                        </div>
                                        <?php echo $test->description; ?>

                                    </div>
                                    <div class="testimonial-content">
                                        <div class="testimonial-author-img">
                                            <img src="<?php echo e(asset('backend/images/testimonial/' . $test->image)); ?>"
                                                onerror="this.onerror=null; this.src='<?php echo e(asset('frontend/img/testimonial/01.jpg')); ?>'"
                                                alt="">
                                        </div>
                                        <div class="testimonial-author-info">
                                            <h4><?php echo e($test->title); ?></h4>
                                            <p><?php echo e($test->designation); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- testimonial-area end -->


        <!-- clients area -->
        <div class="portfolio-area py-50">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 mx-auto">
                        <div class="site-heading text-center">
                            <span class="site-title-tagline"><i class="far fa-solar-panel"></i> Our Clients</span>
                            <h2 class="site-title">Our <span>clients</span> trust us to provide reliable </h2>
                        </div>
                    </div>
                </div>
                <div class="row popup-gallery">
                    <div class="portfolio-slider owl-carousel">
                        <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="portfolio-item">
                                <div class="portfolio-img">
                                    <img class="img-fluid" src="<?php echo e(asset('backend/images/client/' . $client->image)); ?>"
                                        alt="">
                                    <a class="popup-img portfolio-link"
                                        href="<?php echo e(asset('backend/images/client/' . $client->image)); ?>"> <i
                                            class="far fa-plus"></i></a>
                                </div>
                                <div class="portfolio-content">
                                    <div class="portfolio-info">
                                        <h4><a href="#"><?php echo e($client->title); ?></a></h4>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- clients area end -->

    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/frontend/index.blade.php ENDPATH**/ ?>