<?php

  $colleges=App\Models\College::orderBy('id', 'desc')->where('delete_status','0')->get();
  $courses=App\Models\Course::orderBy('id', 'desc')->where('delete_status','0')->take('10')->get();
  $setup =App\Models\WebsiteSetup::orderBy('id','desc')->where('delete_status','0')->first();

?>

<?php if(Route::current()->getName() != 'college'): ?>
<!-- client-section -->
    <div class="prt-row padding_zero-section home01-client-section clearfix border-top">
        <div class="container-fluid">
            <!-- row -->
            <div class="row text-center">
                <div class="col-md-12">
                    <!-- slick_slider -->
                    <div class="slick_slider row" data-slick='{"slidesToShow": 7, "slidesToScroll": 1, "arrows":false, "autoplay":false, "infinite":true, "responsive": [{"breakpoint":1200,"settings":{"slidesToShow": 5}}, {"breakpoint":1024,"settings":{"slidesToShow": 4}}, {"breakpoint":777,"settings":{"slidesToShow": 3}}, {"breakpoint":575,"settings":{"slidesToShow": 3}}, {"breakpoint":420,"settings":{"slidesToShow": 3}}]}'>
                        <?php $__currentLoopData = $colleges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $college): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="col-lg-12">
                            <div class="client-box style1">
                                <div class="client-thumbnail">
                                    <img class="img-fluid" src="<?php echo e(asset('../backend/images/colleges/'.$college->image)); ?>" alt="<?php echo e($college->name); ?>" title="<?php echo e($college->name); ?>">
                                </div>
                            </div>
                        </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div><!-- slick_slider end -->
                </div>
            </div><!-- row end -->
        </div>
    </div>
<!-- client-section-end -->
<?php endif; ?>


</div><!-- site-main end-->

<!-- footer start -->
<footer class="footer widget-footer clearfix">
    <div class="second-footer prt-bgimage-yes bg-footer prt-bg bg-base-dark">
        <div class="prt-row-wrapper-bg-layer prt-bg-layer"></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widgte-text">
                            <img src="<?php echo e(asset('../backend/images/website/'.$setup->footer_logo)); ?>"  width="280" alt="Logo" onerror="this.src='<?php echo e(asset('frontend/images/footer-logo.png')); ?>';this.onerror='';">
                            <hr>
                            <?php echo $setup->about_footer; ?>

                        </div>
                        <div class="widget_social">
                            <div class="social-icons social-hover">
                                <ul class="social-icons d-flex">
                                    <li>
                                        <a class="prt-social-instagram" href="<?php echo e($setup->instagram_link); ?>" target="_blank"><i class="icon-instagram"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-facebook" href="<?php echo e($setup->facebook_link); ?>" target="_blank"><i class="icon-facebook"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-twitter" href="<?php echo e($setup->twitter_link); ?>" target="_blank"><i class="icon-twitter"></i></a>
                                    </li>

                                    <li>
                                        <a class="prt-social-linkedin" href="<?php echo e($setup->linkedin_link); ?>" target="_blank"><i class="icon-linkedin"></i></a>
                                    </li>
                                    <li>
                                        <a class="prt-social-youtube" href="<?php echo e($setup->youtube_link); ?>" target="_blank"><i class="icon-youtube"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Our Courses</h3>
                            </div>
                            <ul class="menu-footer-quick-links">

                                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <li><a href="<?php echo e(route('viewcourses', $course->slug)); ?>"><i class="fa fa-angle-right"></i><?php echo e($course->course_name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget">
                        <div class="widget_nav_menu">
                            <div class="widget-title">
                                <h3>Quick Links</h3>
                            </div>

                            <ul class="menu-footer-quick-links">
                                <li><a href="<?php echo e(route('about')); ?>"><i class="fa fa-angle-right"></i>About Us</a></li>
                                <li><a href="<?php echo e(route('registration_form')); ?>"><i class="fa fa-angle-right"></i> Registration Forms</a></li>
                                <li><a href="#"><i class="fa fa-angle-right"></i>Our Services</a></li>
                                <li><a href="<?php echo e(route('college')); ?>"><i class="fa fa-angle-right"></i>All Colleges</a></li>
                                <li><a href="<?php echo e(route('courses')); ?>"><i class="fa fa-angle-right"></i>Our Courses</a></li>
                                <li><a href="<?php echo e(route('gallery')); ?>"><i class="fa fa-angle-right"></i>Gallery</a></li>
                                <li><a href="<?php echo e(route('contact-us')); ?>"><i class="fa fa-angle-right"></i>Contact Us</a></li>
                            </ul>

                        </div>

                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 widget-area">
                    <div class="widget-title">
                        <h3>Get In Touch</h3>
                    </div>
                    <div class="res-767-pb-18">
                        <p> <?php echo $setup->contact_address; ?></p>
                        <p><strong>Front Desk : </strong><a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>">+91-<?php echo e($setup->contact_phone_1); ?></a>, <a href="tel:+91-<?php echo $setup->contact_phone_2; ?>"><?php echo $setup->contact_phone_2; ?></a></p>
                        <p><strong>Vignans Vihar Colony Hawaiadda Dhanbad :</strong> <a href="tel:+91-9341811913">+91-9341811913</a></p>
                        <p><strong>Yamuna Appartment Boring Road Patna Bihar :</strong> <a href="tel:+91-9341811913">+91-9341811913</a></p>
                        <p><strong>Email : </strong> <a href="mailto:<?php echo e($setup->contact_email_1); ?>"><?php echo e($setup->contact_email_1); ?></a></p>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="bottom-footer-text prt-bg copyright">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="text-left">
                        <span class="cpy-text"> © 2023 <a href="#" class=" font-weight-500"> <?php echo $setup->copyright_text; ?> </a>  All Rights Reserved.</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer><!-- footer end -->

  <!-- The Modal -->
  <div class="modal" id="myModal">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">

        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Enquiry Now</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa fa-times" aria-hidden="true"></i></button>
        </div>

        <!-- Modal body -->
        <div class="modal-body">
            <div class="row">
                <form action="<?php echo e(route('contactform')); ?>" class="contact_form clearfix" method="post">
                    <?php echo csrf_field(); ?>
                        <?php if($message = Session::get('success')): ?>
                            <div class="alert alert-success">
                            <p><?php echo e($message); ?></p>
                            </div>
                        <?php endif; ?>
                    <div class="row">
                        <div class="col-md-12">
                            <input type="text" name="name" class="form-control" value="<?php echo e(old('name')); ?>" placeholder="Your Name *" required="">
                                <?php if($errors->has('name')): ?>
                                <div class="text-danger"><?php echo e($errors->first('name')); ?></div>
                                <?php endif; ?>
                        </div>

                        <div class="col-md-12">
                            <input type="email" name="email" class="form-control" value="<?php echo e(old('email')); ?>" placeholder="Your Email *" required="">
                                <?php if($errors->has('email')): ?>
                                    <div class="text-danger"><?php echo e($errors->first('email')); ?></div>
                                <?php endif; ?>
                        </div>

                        <div class="col-md-12">
                            <input type="number" name="number" class="form-control" value="<?php echo e(old('number')); ?>" placeholder="Your Number *" required="">
                                <?php if($errors->has('number')): ?>
                                    <div class="text-danger"><?php echo e($errors->first('number')); ?></div>
                                <?php endif; ?>
                        </div>

                        <div class="col-md-12">
                            <input type="text" name="subject" class="form-control" value="<?php echo e(old('subject')); ?>" placeholder="Your Subject *">
                                <?php if($errors->has('number')): ?>
                                    <div class="text-danger"><?php echo e($errors->first('subject')); ?></div>
                                <?php endif; ?>
                        </div>

                        <div class="col-md-12">
                            <textarea name="message" class="form-control textarea" placeholder="Type Your Message Here . . ."><?php echo e(old('message')); ?></textarea>
                        </div>
                        <div class="mt-5 text-center">
                            <button class="submit prt-btn prt-btn-size-md prt-btn-shape-round prt-btn-style-fill prt-btn-color-skincolor" type="submit" value="submit">Submit Here <i class="fa fa-angle-right"></i></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

      </div>
    </div>
  </div>
<!-- back-to-top start -->
<a id="totop" href="#top">
    <i class="fa fa-angle-up"></i>
</a>
<!-- back-to-top end -->

</div><!-- page end -->
<!-- Javascript -->
<script src="<?php echo e(asset('frontend/js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-migrate-3.3.2.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/bootstrap.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/aos.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-validate.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.prettyPhoto.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-waypoints.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/numinate.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/imagesloaded.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery-isotope.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/jquery.twentytwenty.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/circle-progress.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/js/main.js')); ?>"></script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\corbital_laravel\resources\views/frontend/layouts/footer.blade.php ENDPATH**/ ?>