<?php $__env->startSection('content'); ?>

<!-- page-title -->
<div class="prt-titlebar-wrapper prt-bg about-img">
    <div class="prt-titlebar-wrapper-bg-layer prt-bg-layer"></div>
    <div class="prt-titlebar-wrapper-inner">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="prt-page-title-row-heading">
                        <div class="page-title-heading">
                            <h2 class="title"><?php echo e($view_courses->course_name); ?></h2>
                        </div>
                        <div class="breadcrumb-wrapper">
                            <i class="flaticon-home"></i>
                            <span>
                                <a title="Homepage" href="/">Home</a>
                            </span>
                            <div class="prt-sep"> - </div>
                            <span><?php echo e($view_courses->course_name); ?></span>
                            <div class="prt-sep"> - </div>
                            <span><?php echo e($view_courses->course_duration); ?></span>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- page-title end -->


<!-- ==================== Start Courses Details ==================== -->

<section class="sidebar prt-sidebar-right clearfix">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 content-area">
                <div class="left-side-area">
                    <div class="image-box">
                        <figure>
                            <img src="<?php echo e(asset('../backend/images/courses/'.$view_courses->course_img)); ?>" class="w-100" alt="">
                        </figure>
                        
                    </div>
                    <div class="image-content">
                        <div class="prt-timelineboxes-wrapper">
                            <div class="prt-timelinebox-content stepline">
                                <div class="prt-box-title">
                                    <h3><?php echo e($view_courses->course_name); ?></h3>
                                </div>
                                <div class="prt-box-desc">
                                    <?php echo $view_courses->course_description; ?>

                                </div>
                            </div>

                            <div class="prt-timelinebox-content stepline">
                                <div class="prt-box-title">
                                    <h3>Duration</h3>
                                </div>
                                <div class="prt-box-desc">
                                    <?php echo e($view_courses->course_duration); ?>

                                </div>
                            </div>

                            <div class="prt-timelinebox-content stepline">
                                <div class="prt-box-title">
                                    <h3>Eligibility</h3>
                                </div>
                                <div class="prt-box-desc">
                                    <?php echo $view_courses->course_eligibility; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="service-title bg-base-skin text-center mt-0">
                                <div class="service-header p-25">
                                    <h3 class="text-base-white mb-0">For 100% Confirmed Seats Call Now - <a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>"><i class="flaticon-call"></i> +91-<?php echo e($setup->contact_phone_1); ?></a></h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 widget-area sidebar-right prtcol-bgcolor-yes prt-bg prt-right-span bg-base-grey">
                <div class="prt-col-wrapper-bg-layer prt-bg-layer"></div>
                <div class="layer-content">
                    <aside class="widget widget-categories with-title">
                        <h3 class="widget-title">Enquiry Now</h3>
                            <?php if(Session::has('success')): ?>
                                <div class="alert alert-success">
                                    <?php echo e(Session::get('success')); ?>

                                </div>
                            <?php endif; ?>
                            <form id="contact_form" action="<?php echo e(route('course_enquiry.store')); ?>" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-12">
                                    <input type="text" name="name" class="form-control" value="<?php echo e(old('name')); ?>" placeholder="Your Name *">
                                            <?php if($errors->has('name')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('name')); ?></div>
                                            <?php endif; ?>
                                    </div>

                                    <div class="col-md-12">
                                    <input type="email" name="email" class="form-control" value="<?php echo e(old('email')); ?>" placeholder="Your Email *">
                                        <?php if($errors->has('email')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('email')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-12">
                                    <input type="number" name="phone" class="form-control" value="<?php echo e(old('phone')); ?>" placeholder="Your  Number *">
                                        <?php if($errors->has('phone')): ?>
                                            <div class="text-danger"><?php echo e($errors->first('phone')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-12">
                                        <input type="text" name="subject" class="form-control" value="<?php echo e(old('subject')); ?>" placeholder="Your  Subject">
                                    </div>
                                    <input type="hidden" name="course_name" class="form-control" value="<?php echo e($view_courses->course_name); ?>" >
                                    <div class="mt-5">
                                        <button class="submit prt-btn prt-btn-size-md prt-btn-shape-round prt-btn-style-fill prt-btn-color-skincolor" type="submit" value="submit">Submit Here <i class="fa fa-angle-right"></i></button>
                                    </div>
                                </div>
                            </form>
                     </aside>
                    <aside class="widget widget-recent-post with-title">
                        <h3 class="widget-title">Other Courses</h3>
                        <ul class="widget-post prt-recent-post-list">
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <div class="post-img">
                                        <a href="<?php echo e(route('viewcourses',$course->slug)); ?>">
                                            <img width="80" height="60" src="<?php echo e(asset('../backend/images/courses/'.$course->course_img)); ?>" alt="<?php echo e($course->course_name); ?>">
                                        </a>
                                    </div>
                                    <div class="post-detail">
                                        <span class="post-date"><?php echo e($course->course_duration); ?></span>
                                        <a href="<?php echo e(route('viewcourses',$course->slug)); ?>"><?php echo e($course->course_name); ?></a>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </aside>

                    <aside class="widget widget-contact-info with-title">
                        <h3 class="widget-title">Free Consultation </h3>
                        <div class="widget-contact">
                            <div class="featured-icon-box featured-icon-box-widget">
                                <div class="featured-icon">
                                    <div class="prt-icon prt-icon_element-onlytxt prt-icon_element-size-sm">
                                        <i class="flaticon-location"></i>
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Address :</h3>
                                    </div>
                                    <div class="featured-desc">
                                        <p><?php echo e($setup->contact_address); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="featured-icon-box featured-icon-box-widget">
                                <div class="featured-icon">
                                    <div class="prt-icon prt-icon_element-onlytxt prt-icon_element-size-sm">
                                        <i class="flaticon-call"></i>
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Call Us :</h3>
                                    </div>
                                    <div class="featured-desc">
                                        <p><a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>">+91-<?php echo e($setup->contact_phone_1); ?></a></p>
                                    </div>
                                </div>
                            </div>
                            <div class="featured-icon-box featured-icon-box-widget">
                                <div class="featured-icon">
                                    <div class="prt-icon prt-icon_element-onlytxt prt-icon_element-size-sm">
                                        <i class="flaticon-email"></i>
                                    </div>
                                </div>
                                <div class="featured-content">
                                    <div class="featured-title">
                                        <h3>Email :</h3>
                                    </div>
                                    <div class="featured-desc">
                                        <p><a href="mailto:<?php echo e($setup->contact_email_1); ?>"><?php echo e($setup->contact_email_1); ?></a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== End Courses Details ==================== -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\corbital_laravel\resources\views/frontend/view-courses.blade.php ENDPATH**/ ?>