<?php

namespace App\Http\Controllers;

use App\Models\CourseCategory;
use Illuminate\Http\Request;

class CourseCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $coursecat = CourseCategory::orderBy('id','desc')->where('delete_status','0')->get();
        return view('backend.course-category.index', compact('coursecat'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $coursercat=$request->all();

        if($request->file('course_img')){
            $imageName = time().'.'.$request->course_img->extension();
            $request->course_img->move(public_path('backend/images/coursecat'), $imageName);
            $coursercat['course_img']=$imageName;
        }


        $coursercat['slug']=\Str::slug($request->course_name).'-'.rand();
        CourseCategory::create($coursercat);


        return redirect()->route('service-category.index')
        ->with('success','Course Category created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CourseCategory  $courseCategory
     * @return \Illuminate\Http\Response
     */
    public function show(CourseCategory $courseCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CourseCategory  $courseCategory
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = CourseCategory::find($id);
        $coursecat = CourseCategory::orderBy('id','desc')->where('delete_status','0')->get();
        return view('backend.course-category.index', compact('coursecat' , 'category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CourseCategory  $courseCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $coursercat = CourseCategory::find($id);
        $input=$request->all();

        if($request->file('course_img')){
            $imageName = time().'.'.$request->course_img->extension();
            $request->course_img->move(public_path('backend/images/coursecat'), $imageName);
            $input['course_img']=$imageName;
        }

        $coursercat->update($input);

        return redirect()->route('service-category.index')
        ->with('success','Course Category Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CourseCategory  $courseCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $coursercat= CourseCategory::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('service-category.index')
                        ->with('success','Course Category deleted successfully');
    }
}
