<?php

namespace App\Http\Controllers;

use App\Models\Enquiry;
use App\Models\SvyscExam;
use Illuminate\Http\Request;

class EnquiryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $enquirys = Enquiry::orderBy('id','desc')->where('delete_status','0')->get();
        return view('backend.enquiry.index', compact('enquirys'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation=$request->validate([
            'name' => 'required',
            'email' => 'required',
            'number' => 'required',
        ]);

        $enquiry = new Enquiry;
        $enquiry->name = $request->name;
        $enquiry->number = $request->number;
        $enquiry->email = $request->email;
        $enquiry->subject = $request->subject;
        // $enquiry->services = $request->services;
        // $enquiry->city = $request->city;
        // $enquiry->state = $request->state;
        $enquiry->message = $request->message;
        $enquiry->save();
        return back()->with('success','Enquiry Sent Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([

            'name' => 'required',
            'number' => 'required',
            'email' => 'required',

        ]);

        $enquiry = Enquiry::find($id);
        $enquiry->name = $request->name;
        $enquiry->number = $request->number;
        $enquiry->email = $request->email;
        // $enquiry->subject = $request->subject;
        // $enquiry->services = $request->services;
        $enquiry->message = $request->message;
        $enquiry->save();
        return redirect()->route('enquiry.index')
        ->with('success','Enquiry Has Been updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $enquiry= Enquiry::where('id', $id)->update(array('delete_status' => 1));

        return back()->with('success','Enquiry has been deleted successfully');
    }

    public function registrationForm (Request $request)
    {

        $condition_school=[];
        $condition_state=[];
        $condition_district=[];
        $condition_education_board=[];
        $condition_which_class=[];
        $condition_gender=[];
        $condition_career_choice=[];
        $search = $request->search;


        $school_name=explode(",",$request->school_name);
        $state=explode(",",$request->state);
        $district=explode(",",$request->district);
        $education_board=explode(",",$request->education_board);
        $class = explode(",",$request->which_class);
        $genders = explode(",",$request->gender);



        if(!empty($request->school_name))
        {
            foreach($school_name as $school)
            {
                array_push($condition_school,['school_name'=>$school]);
            }
        }

        if(!empty($request->state))
        {
            foreach($state as $stat)
            {
                array_push($condition_state,['state'=>$stat]);
            }
        }
        if(!empty($request->district))
        {
            foreach($district as $dis)
            {
                array_push($condition_district,['district'=>$dis]);
            }
        }
        if(!empty($request->education_board))
        {
            foreach($education_board as $education)
            {
                array_push($condition_education_board,['education_board'=>$education]);
            }
        }
        if(!empty($request->which_class))
        {
            foreach($class as $clas)
            {
                array_push($condition_which_class,['which_class'=>$clas]);
            }
        }
        if(!empty($request->gender))
        {
            foreach($genders as $gender)
            {
                array_push($condition_gender,['gender'=>$gender]);
            }
        }


        $registrationform = SvyscExam::orderBy('id','desc')->where('delete_status','0')->where(function ($query) use ($condition_school){
            foreach ($condition_school as $key=>$value)
            {
                $query->orWhere($value);
            }
            })->where(function ($query) use ($condition_state){
                foreach ($condition_state as $key=>$value)
                {
                    $query->orWhere($value);
                }
                })->where(function ($query) use ($condition_district){
                foreach ($condition_district as $key=>$value)
                {
                    $query->orWhere($value);
                }
                })->where(function ($query) use ($condition_education_board){
                foreach ($condition_education_board as $key=>$value)
                {
                    $query->orWhere($value);
                }
                })->where(function ($query) use ($condition_which_class){
                foreach ($condition_which_class as $key=>$value)
                {
                    $query->orWhere($value);
                }
                })->where(function ($query) use ($condition_gender){
                foreach ($condition_gender as $key=>$value)
                {
                    $query->orWhere($value);
                }
                })->where(function ($query) use ($condition_career_choice){
                foreach ($condition_career_choice as $key=>$value)
                {
                    $query->orWhere($value);
                }
                });

                if($search != null)
                {
                  $registrationform= $registrationform->where(function ($query) use ($search) {
                  $query->orWhere('name', 'like', '%'.$search.'%')->orWhere('phone', 'like', '%'.$search.'%');
                  });
                }


            $registrationform=$registrationform->paginate(20);

            if($request->ajax()){
                return view('backend.registration-form.table',compact('registrationform'));
           }

        return view('backend.registration-form.index', compact('registrationform'));
    }

}
