<?php

namespace App\Http\Controllers;

use App\Models\Gallery;
use Illuminate\Http\Request;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $gallerys = Gallery::orderBy('id', 'desc')->where('delete_status','0')->get();
        return view('backend.gallery.index' , compact('gallerys'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $gallery=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/gallery'), $imageName);
            $gallery['image']=$imageName;
        }

        // $blog['slug']=\Str::slug($request->title).'-'.rand();
        Gallery::create($gallery);


        return redirect()->route('gallery.index')
        ->with('success','Gallery Updated successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $gallery=Gallery::find($id);
        $gallerys = Gallery::orderBy('id', 'desc')->where('delete_status','0')->get();
        return view('backend.gallery.index', compact('gallery', 'gallerys' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $gallery = Gallery::find($id);
        $input=$request->all();

        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/gallery'), $imageName);
            $input['image']=$imageName;
        }

        $gallery->update($input);

        return redirect()->route('gallery.index')
        ->with('success','Gallery Updated successfully.');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $gallery= Gallery::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('gallery.index')
                        ->with('success','Gallery deleted successfully');
    }
}
