<?php

namespace App\Http\Controllers;

use App\Models\Team;
use Illuminate\Http\Request;

class TeamController extends Controller
{
    public function index(){
        $teams = Team::where('status','1')->where('delete_status', '0')->latest()->get();
        return view('backend.team.index', compact('teams'));
    }

    public function store(Request $request){
        $team = $request->all();
        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/team'), $imageName);
            $team['image']=$imageName;
        }
        Team::create($team);
        return back()->with('success', 'Team added successfully');
    }

    public function edit(Team $team){
        $teams = Team::where('status','1')->where('delete_status', '0')->latest()->get();
        return view('backend.team.index', compact('team', 'teams'));
    }

    public function update(Request $request, $id){
        $team = Team::find($id);
        $input = $request->all();
        if($request->file('image')){
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('backend/images/team'), $imageName);
            $team['image']=$imageName;
        }
        $team->update($input);
        return redirect()->route('team.index')->with('success', 'Team updated successfully');
    }

    public function destroy($id)
    {
        $team = Team::where('id', $id)->update(array('delete_status' => 1));

        return redirect()->route('team.index')
                        ->with('success','Team deleted successfully');
    }

    public function changeStatus(Request $request)
    {
        $team = Team::find($request->id);
        $team->status = $request->status;
        $team->save();

        return response()->json(['success'=>'Status change successfully.']);
    }
}
