@extends('backend.layouts.app')
@section('content')
    <div class="content-page">
        <div class="content">
            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="#" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-reply me-1"></i> About Page
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">About Page</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->

                <div class="card">
                    <div class="card-body">
                        @if (isset($aboutpage) && isset($aboutpage->id))
                            <form action="{{ route('aboutpage.update', $aboutpage->id) }}" method="POST"
                                enctype="multipart/form-data" class="needs-validation" novalidate>
                                @method('PUT')
                            @else
                                <form action="{{ route('aboutpage.store') }}" method="POST" enctype="multipart/form-data"
                                    class="needs-validation" novalidate>
                        @endif

                        @csrf

                        <div class="row">

                            <div class="mb-3 col-md-12">
                                <label class="form-label"> About</label>
                                <textarea class="ckeditor" name="about_text" rows="8">{{ old('about_text', optional($aboutpage)->about_text) }}</textarea>
                            </div>

                            <div class="mb-3 col-md-12">
                                <label class="form-label"> Mission</label>
                                <textarea class="ckeditor" name="mission" rows="8">{{ old('mission', optional($aboutpage)->mission) }}</textarea>
                            </div>

                            <div class="mb-3 col-md-12">
                                <label class="form-label"> Vision</label>
                                <textarea class="ckeditor" name="vision" rows="8">{{ old('vision', optional($aboutpage)->vision) }}</textarea>
                            </div>

                            <div class="mb-3 col-md-12">
                                <label class="form-label"> Values</label>
                                <textarea class="ckeditor" name="value" rows="8">{{ old('value', optional($aboutpage)->value) }}</textarea>
                            </div>

                            <div class="mb-3 col-md-3">
                                <label class="form-label" for="validationCustom05">About</label>
                                <input type="file" id="about_image" name="about_image" class="form-control">

                                <img class="mt-2" id="about_img"
                                    src="{{ URL::asset('backend/images/about/' . old('about_image', optional($aboutpage)->about_image)) }}"
                                    onerror="this.onerror=null; this.src='../backend/images/no_image.png'"
                                    style="width: 35%;" />

                            </div>

                            <div class="mb-3 col-md-3">
                                <label class="form-label">Mission</label>
                                <input type="file" name="mission_image" id="mission_image" class="form-control">

                                <img class="mt-2" id="mission_img"
                                    src="{{ URL::asset('backend/images/about/' . old('mission_image', optional($aboutpage)->mission_image)) }}"
                                    onerror="this.onerror=null; this.src='../backend/images/no_image.png'"
                                    style="width: 35%;" />

                            </div>

                            <div class="mb-3 col-md-3">
                                <label class="form-label">Vision</label>
                                <input type="file" name="vision_image" id="vision_image" class="form-control">

                                <img class="mt-2" id="vision_img"
                                    src="{{ URL::asset('backend/images/about/' . old('vision_image', optional($aboutpage)->vision_image)) }}"
                                    onerror="this.onerror=null; this.src='../backend/images/no_image.png'"
                                    style="width: 35%;" />

                            </div>

                            <div class="mb-3 col-md-3">
                                <label class="form-label">Value</label>
                                <input type="file" name="value_image" id="value_image" class="form-control">

                                <img class="mt-2" id="value_img"
                                    src="{{ URL::asset('backend/images/about/' . old('value_image', optional($aboutpage)->value_image)) }}"
                                    onerror="this.onerror=null; this.src='../backend/images/no_image.png'"
                                    style="width: 35%;" />

                            </div>

                            <div class="mb-3 col-md-12">
                                <button class="btn btn-primary" type="submit">Submit</button>
                            </div>

                        </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    <script>
        about_image.onchange = evt => {
            const [file] = about_image.files
            if (file) {
                about_img.src = URL.createObjectURL(file)
            }
        }

        mission_image.onchange = evt => {
            const [file] = mission_image.files
            if (file) {
                mission_img.src = URL.createObjectURL(file)
            }
        }


        vision_image.onchange = evt => {
            const [file] = vision_image.files
            if (file) {
                vision_img.src = URL.createObjectURL(file)
            }
        }

        value_image.onchange = evt => {
            const [file] = value_image.files
            if (file) {
                value_img.src = URL.createObjectURL(file)
            }
        }
    </script>
@endsection
