@extends('backend.layouts.app')
@section('content')
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="{{route('client.index')}}" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-reply me-1"></i> All Client
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Client</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped table-centered mb-0">
                                    <thead>
                                        <tr>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($clients as $data)
                                            <tr>
                                                <td class="table-user">
                                                    <img id="blah"
                                                        src="{{ URL::asset('backend/images/client/' . $data->image) }}"
                                                        alt="your image"
                                                        onerror="this.onerror=null; this.src='{{asset('backend/images/no_image.svg')}}'" />
                                                </td>
                                                <td>{{ $data->title }}</td>
                                                <td>
                                                    <!-- Switch-->
                                                    <div>
                                                        <input type="checkbox" data-id="{{ $data->id }}"
                                                            id="switch_{{ $data->id }}" class="toggle-classs"
                                                            value="{{ $data->id }}" {{ $data->status ? 'checked' : '' }}
                                                            data-switch="success" />
                                                        <label for="switch_{{ $data->id }}" data-on-label="Yes"
                                                            data-off-label="No" class="mb-0 d-block"></label>
                                                    </div>
                                                </td>
                                                <td class="table-action d-flex">

                                                    <a href="{{ route('client.edit', $data->id) }}" class="action-icon">
                                                        <i class="mdi mdi-pencil"></i></a>

                                                    <form action="{{ route('client.destroy', $data->id) }}" method="POST">
                                                        @method('DELETE')
                                                        @csrf
                                                        <button class="btn text-danger btn-sm"
                                                            onclick="return areyousure();  " title="Delete"
                                                            class="action-icon">
                                                            <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="card">
                            <div class="card-body">
                                @if (isset($client) && isset($client->id))
                                    <form action="{{ route('client.update', $client->id) }}" method="POST"
                                        enctype="multipart/form-data" class="needs-validation" novalidate>
                                        @method('PUT')
                                    @else
                                        <form action="{{ route('client.store') }}" method="POST"
                                            enctype="multipart/form-data" class="needs-validation" novalidate>
                                @endif

                                @csrf


                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Client Name</label>
                                        <input type="text" class="form-control" name="title"
                                            @if (isset($client)) value="{{ old('title', optional($client)->title) }}" @endif required>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file" id="image" name="image" class="form-control">
                                        @if (isset($client))
                                            <img id="img" src="{{ URL::asset('backend/images/client/' . old('image', optional($client)->image)) }}"
                                                onerror="this.onerror=null; this.src='{{asset('backend/images/no_image.png')}}'"
                                                style="width: 35%;" />
                                        @else
                                            <img class="mt-2" id="img" src="{{asset('backend/images/no_image.png')}}" onerror="this.onerror=null;this.src='{{asset('backend/images/no_image.png')}}'" height="100px" width="100px">
                                        @endif
                                    </div>



                                    <div class="mb-3 col-md-12">
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        image.onchange = evt => {
            const [file] = image.files
            if (file) {
                img.src = URL.createObjectURL(file)
            }
        }
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "{{ route('clientstatus') }}",
                    data: {
                        'status': status,
                        'id': id
                    },
                    success: function(data) {
                        {

                            $.NotificationApp.send("Success", data.success, "top-right",
                                "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        });
    </script>
@endsection
