@extends('backend.layouts.app')
@section('content')

<div class="content-page">
    <div class="content">

          <!-- Start Content-->
          <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <a href="{{ route('service.index') }}" class="btn btn-sm btn-dark waves-effect">
                                    <i class="dripicons-reply me-1"></i> Back To All Services
                                </a>
                            </ol>
                        </div>
                        <h4 class="page-title">Update Service</h4>
                    </div>
                </div>
            </div>

            <!-- end page title -->


                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('service.update',$courses->id) }}" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                            @csrf
                            @method('PUT')
                            <div class="row">

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Select Category</label>
                                    <select class="form-select" id="example-select" name="course_category_id" required>
                                        <option>Select Here</option>
                                        @foreach($category as $categories)
                                            <option value="{{ $categories->id }}" @if ($categories->id==$courses->course_category_id){{'selected'}}@endif>{{ $categories->course_name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label" >Service Name</label>
                                    <input type="text" class="form-control" name="course_name" value="{{$courses->course_name}}">
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label" >Service Fees</label>
                                    <input type="text" class="form-control" name="course_fees" value="{{$courses->course_fees}}">
                                </div>

                                <div class="mb-3 col-md-12">
                                    <label class="form-label">Description</label>
                                    <textarea class="ckeditor" name="course_description" value="{{$courses->course_description}}" rows="5">{{$courses->course_description}}</textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label" >Image</label>
                                    <input type="file" id="image" name="course_img" value="{{$courses->course_img}}" class="form-control">
                                    <img class="mt-2" id="img" src="{{asset('backend/images/courses/'. $courses->course_img)}}" alt="{{$courses->course_name}}" onerror="this.onerror=null;this.src='{{asset('backend/images/no_image.png')}}'" height="100px" width="100px">
                                </div>
                                <div class="mb-3 col-md-12">
                                  <button class="btn btn-primary" type="submit">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!-- container -->
    </div>
    <!-- content -->

</div>

</div>
<!-- END wrapper -->

<script>
    image.onchange = evt => {
        const [file] = image.files
        if (file) {
            img.src = URL.createObjectURL(file)
        }
    }
</script>

@endsection
