@extends('backend.layouts.app')
@section('content')

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="{{route('service.create')}}" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-plus me-1"></i> Add Service
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">All Service</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                   <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-striped table-centered mb-0">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Category</th>
                                        <th>Name</th>
                                        <th>Fees</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($courses as $course)

                                        <tr>
                                            <td class="table-user">
                                                <img id="blah" src="{{ URL::asset('backend/images/courses/' . $course->course_img) }}"
                                                alt="your image" onerror="this.onerror=null; this.src='{{asset('backend/images/no_image.svg')}}'"/>
                                            </td>
                                            <td>{{$course->category->course_name}}</td>

                                            <td>{{$course->course_name}}</td>
                                            <td>{{$course->course_fees}}</td>
                                            <td>{!!$course->course_description!!}</td>

                                            <td class="table-action d-flex">

                                                <a href="{{ route('service.edit',$course->id) }}" class="action-icon">
                                                     <i class="mdi mdi-pencil"></i></a>

                                                <form action="{{ route('service.destroy', $course->id) }}" method="POST">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn text-danger btn-sm"
                                                        onclick="return areyousure();  " title="Delete"  class="action-icon">
                                                         <i class="mdi mdi-delete"
                                                            aria-hidden="true"></i> </button>
                                                </form>
                                            </td>
                                        </tr>


                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                 </div>
              </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    @endsection
