@extends('backend.layouts.app')
@section('content')

<div class="content-page">
    <div class="content">
          <!-- Start Content-->
          <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <a href="{{ route('testimonial.index') }}" class="btn btn-sm btn-dark waves-effect">
                                    <i class="dripicons-reply me-1"></i> Back To All Testimonials
                                </a>
                            </ol>
                        </div>
                        <h4 class="page-title">Update Testimonial</h4>
                    </div>
                </div>
            </div>

            <!-- end page title -->

            <div class="row">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('testimonial.update',$testimonial->id) }}" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <div class="col-6 mb-3">
                                    <label class="form-label" for="validationCustom01">Title</label>
                                    <input type="text" class="form-control" name="title" id="validationCustom01" value="{{$testimonial->title}}">
                                </div>

                                <div class="col-6 mb-3">
                                    <label class="form-label" for="validationCustom02">Designation</label>
                                    <input type="text" class="form-control" name="designation" id="validationCustom01"
                                        placeholder="Designation" value="{{$testimonial->designation}}" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Description</label>
                                    <textarea class="ckeditor"  name="description" value="{{$testimonial->description}}" rows="5">{{$testimonial->description}}</textarea>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label" >Image</label>
                                    <input type="file" id="image" name="image" value="{{$testimonial->image}}" class="form-control">
                                    <img class="mt-2" id="img" src="{{asset('backend/images/testimonial/'.$testimonial->image)}}" alt="{{$testimonial->name}}" onerror="this.onerror=null;this.src='{{asset('backend/images/no_image.png')}}'" height="100px" width="100px">
                                </div>
                            </div>
                            <button class="btn btn-primary" type="submit">Submit</button>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!-- container -->
    </div>
    <!-- content -->

</div>

</div>
<!-- END wrapper -->

<script>
    image.onchange = evt => {
        const [file] = image.files
        if (file) {
            img.src = URL.createObjectURL(file)
        }
    }
</script>


@endsection
