@extends('frontend.layouts.app')
@section('content')
    <!-- page-title -->
    <div class="prt-titlebar-wrapper prt-bg about-img">
        <div class="prt-titlebar-wrapper-bg-layer prt-bg-layer"></div>
        <div class="prt-titlebar-wrapper-inner">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12 text-center">
                        <div class="prt-page-title-row-heading">
                            <div class="page-title-heading">
                                <h2 class="title">Career</h2>
                            </div>
                            <div class="breadcrumb-wrapper">
                                <i class="flaticon-home"></i>
                                <span>
                                    <a title="Homepage" href="/">Home</a>
                                </span>
                                <div class="prt-sep"> - </div>
                                <span>Career at {{ env('APP_NAME') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page-title end -->

    <section class="prt-row clearfix py-5">
        <div class="container" data-aos="fade-up">
            <div class="row mb-4">
                <div class="col-lg-12 col-md-12 col-sm-10 m-auto mb-3">
                    <!--section-title-->
                    <div class="section-title title-style-center_text">
                        <div class="title-header">
                            <div class="sub-head-1">
                                <div class="dotted">
                                    <span class="dot-1"></span>
                                    <span class="dot-2"></span>
                                    <span class="dot-3"></span>
                                </div>
                                <h3>Join Our Team</h3>
                                <div class="dotted">
                                    <span class="dot-1"></span>
                                    <span class="dot-2"></span>
                                    <span class="dot-3"></span>
                                </div>
                            </div>
                            <h2 class="title">Life at <span>{{ env('APP_NAME') }} </span></h2>
                        </div>
                    </div>
                    <!--section-title end-->
                </div>
                <div class="registration_forn col-md-6 offset-lg-3">
                    <form action="{{ route('careerform') }}" class="contact_form clearfix" method="post">
                        @csrf
                        @if ($message = Session::get('success'))
                            <div class="alert alert-success">
                                <p>{{ $message }}</p>
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-6">
                                <label>Full Name <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control" value="{{ old('name') }}"
                                    placeholder="Your Name" required="">
                                @if ($errors->has('name'))
                                    <div class="text-danger">{{ $errors->first('name') }}</div>
                                @endif
                            </div>

                            <div class="col-md-6">
                                <label>Email Address <span class="text-danger">*</span></label>
                                <input type="email" name="email" class="form-control" value="{{ old('email') }}"
                                    placeholder="Your Email" required="">
                                @if ($errors->has('email'))
                                    <div class="text-danger">{{ $errors->first('email') }}</div>
                                @endif
                            </div>

                            <div class="col-md-6">
                                <label>Contact Number <span class="text-danger">*</span></label>
                                <input type="text" name="number" class="form-control" value="{{ old('number') }}"
                                    placeholder="Your Number" oninput="validatePhone(this)" required="">
                                @if ($errors->has('number'))
                                    <div class="text-danger">{{ $errors->first('number') }}</div>
                                @endif
                            </div>

                            <div class="col-md-6">
                                <label>Qualification <span class="text-danger">*</span></label>
                                <input type="text" name="qualification" class="form-control"
                                    value="{{ old('qualification') }}" placeholder="Your Qualifications" required="">
                                @if ($errors->has('qualification'))
                                    <div class="text-danger">{{ $errors->first('qualification') }}</div>
                                @endif
                            </div>

                            <div class="col-md-12">
                                <div class="col-md-12">
                                    <label>Complete Address <span class="text-danger">*</span></label>
                                    <textarea name="address" class="form-control textarea" placeholder="Your Address" required="">{{ old('address') }}</textarea>
                                </div>
                                @if ($errors->has('address'))
                                    <div class="text-danger">{{ $errors->first('address') }}</div>
                                @endif
                            </div>

                            <div class="col-md-12">
                                <label>Message</label>
                                <textarea name="message" class="form-control textarea" rows="4" placeholder="Type Your Message Here . . .">{{ old('message') }}</textarea>
                            </div>
                            <div class="mt-5">
                                <button
                                    class="submit prt-btn prt-btn-size-md prt-btn-shape-round prt-btn-style-fill prt-btn-color-skincolor"
                                    type="submit" value="submit">Submit Here <i class="fa fa-angle-right"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
