<?php $__env->startSection('content'); ?>
    <?php
        $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
    ?>
    <!--==============================
            Breadcumb
            ============================== -->
    <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('frontend/img/breadcumb/breadcumb-bg.jpg')); ?>">
        <div class="container z-index-common">
            <div class="breadcumb-content">
                <h5 class="breadcumb-title">Service Details</h5>
                <div class="breadcumb-menu-wrap">
                    <ul class="breadcumb-menu">
                        <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li><a href="<?php echo e(route('service')); ?>">Our Services</a></li>
                        <li><?php echo e($view_service->course_name); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="service--details space-top space-extra-bottom">
        <div class="container">
            <h3 class="mb-40"><?php echo e($view_service->course_name); ?></h3>
            <?php if(isset($view_service->course_img)): ?>
                <div class="img-box z-index-common mb-40">
                    <div class="icon-box1">
                        <img src="<?php echo e(asset('frontend/img/icons/service-details-icon-1.svg')); ?>" alt="service details icon 1">
                    </div>
                    <img src="<?php echo e(asset('backend/images/courses/' . $view_service->course_img)); ?>" style="aspect-ratio: 1 / 0.5"
                        alt="services">
                </div>
            <?php endif; ?>
            <p>
                <?php echo $view_service->course_description; ?>

            </p>
            
        </div>
    </div>
    <section class="project--layout1 z-index-common space-top overflow-hidden">
        <div class="project__backlay position-absolute z-index-n1">
            <img src="<?php echo e(asset('frontend/img/project/project-img-4.jpg')); ?>" alt="Project">
        </div>
        <div class="project__shape"></div>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-7 col-md-8">
                    <div class="title-area text-center text-md-start">
                        <span class="sec-subtitle2">Services</span>
                        <h2 class="sec-title">Latest Services</h2>
                    </div>
                </div>
                <div class="col-lg-5 col-md-4">
                    <div class="title-area">
                        <div class="d-flex align-items-center gap-2 justify-content-center justify-content-lg-end">
                            <button class="icon-btn style9" data-slick-prev=".vsslider3"><i
                                    class="fal fa-angle-double-left"></i></button>
                            <button class="icon-btn style9" data-slick-next=".vsslider3"><i
                                    class="fal fa-angle-double-right"></i></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row vs-carousel vsslider3" data-dots="false" data-slide-show="4" data-lg-slide-show="2"
                data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="2" data-center-mode="true"
                data-arrows="false">
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-6 col-md-6">
                        <div class="project-block">
                            <div class="project-block__media">
                                <a href="<?php echo e(route('service-detail', $latest->slug)); ?>">
                                    <img class="project-block__img"
                                        src="<?php echo e(asset('backend/images/courses/' . $latest->course_img)); ?>"
                                        onerror="this.onerror=null; this.src='<?php echo e(asset('frontend/img/no_image.jpg')); ?>'" alt="project details">
                                </a>
                            </div>
                            <div class="project-block__content">
                                <h3 class="project-block__title h4">
                                    <a class="project-block__title__link" href="<?php echo e(route('service-detail', $latest->slug)); ?>"><?php echo e($latest->course_name); ?></a>
                                </h3>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\econsultancy\resources\views/frontend/service-details.blade.php ENDPATH**/ ?>