<?php $__env->startSection('content'); ?>
    <div class="search-overlay">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-close">
                    <span class="search-close-line"></span>
                    <span class="search-close-line"></span>
                </div>
                <div class="search-form">
                    <form>
                        <input type="text" class="input-search" placeholder="Search here...">
                        <button type="submit"><i class="bx bx-search"></i></button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="inner-banner" id="banner-opc">
        <div class="container">
            <div class="inner-title text-center">
                <h3>Site Details</h3>
                <ul>
                    <li>
                        <a href="<?php echo e(route('home')); ?>">Home</a>
                    </li>
                    <li>
                        <i class="bx bx-chevrons-right"></i>
                    </li>
                    <li>Site</li>
                    <li>
                        <i class="bx bx-chevrons-right"></i>
                    </li>
                    <li><?php echo e($site->name); ?></li>
                </ul>
            </div>
        </div>
        <div class="inner-shape">
            <img src="<?php echo e(asset('frontend/images/shape/inner-shape.png')); ?>" alt="Images">
        </div>
    </div>


    <div class="service-details-area pt-100 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="service-article">
                        <div class="service-article-img">
                            <?php if(isset($site->image)): ?>
                                <img src="<?php echo e(asset('backend/images/site/' . $site->image)); ?>" alt="Images">
                            <?php else: ?>
                                <h5>No Image Found !</h5>
                            <?php endif; ?>
                        </div>
                        <div class="service-article-content">
                            <div class="blog-article mb-0">
                                <div class="blog-article-title">
                                    <ul>
                                        <li><i class="bx bx-location-plus"></i>
                                            <?php if(isset($site->location)): ?>
                                                <?php echo e($site->location); ?>

                                            <?php else: ?>
                                                Not Found
                                            <?php endif; ?>
                                        </li>
                                        <li><i class="bx bx-show-alt"></i><?php echo e($site->study_indications); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <h2><?php echo e($site->name); ?></h2>
                            <?php echo $site->description; ?>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="side-bar-area">
                        <div class="side-bar-widget">
                            <h3 class="title">Latest Sites</h3>
                            <div class="widget-popular-post">
                                <?php $__currentLoopData = $sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <article class="item">
                                        <a href="<?php echo e(route('showsite', $latest->slug)); ?>" class="thumb">
                                            <?php if(isset($latest->image)): ?>
                                            <span class="full-image cover bg1" role="img"
                                                style="background-image: url('<?php echo e(asset('backend/images/site/' . $latest->image)); ?>');" ></span>
                                            <?php else: ?>
                                            <span class="full-image cover bg1" role="img"
                                                style="background-image: url('<?php echo e(asset('frontend/images/no_image.jpg')); ?>');" ></span>
                                            <?php endif; ?>
                                        </a>
                                        <div class="info">
                                            <a href="<?php echo e(route('showsite', $latest->slug)); ?>">
                                                <h4 class="title-text">
                                                    <?php echo e($latest->name); ?>

                                                </h4>
                                            </a>
                                            <p>
                                                <?php if(isset($latest->location)): ?>
                                                    <?php echo e($latest->location); ?>

                                                <?php else: ?>
                                                    Not Found
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </article>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\analysis_service\resources\views/frontend/view-site.blade.php ENDPATH**/ ?>