<?php $__env->startSection('content'); ?>
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="<?php echo e(route('faq.index')); ?>" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-reply me-1"></i> All Faqs
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Faq</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped table-centered mb-0">
                                    <thead>
                                        <tr>
                                            <th>Question</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($data->question); ?></td>
                                                <td>
                                                    <!-- Switch-->
                                                    <div>
                                                        <input type="checkbox" data-id="<?php echo e($data->id); ?>"
                                                            id="switch_<?php echo e($data->id); ?>" class="toggle-classs"
                                                            value="<?php echo e($data->id); ?>" <?php echo e($data->status ? 'checked' : ''); ?>

                                                            data-switch="success" />
                                                        <label for="switch_<?php echo e($data->id); ?>" data-on-label="Yes"
                                                            data-off-label="No" class="mb-0 d-block"></label>
                                                    </div>
                                                </td>
                                                <td class="table-action d-flex">
                                                    <a href="<?php echo e(route('faq.edit', $data->id)); ?>" class="action-icon">
                                                        <i class="mdi mdi-pencil"></i></a>

                                                    <form action="<?php echo e(route('faq.destroy', $data->id)); ?>" method="POST">
                                                        <?php echo method_field('DELETE'); ?>
                                                        <?php echo csrf_field(); ?>
                                                        <button class="btn text-danger btn-sm"
                                                            onclick="return areyousure();  " title="Delete"
                                                            class="action-icon">
                                                            <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="card">
                            <div class="card-body">
                                <?php if(isset($faq) && isset($faq->id)): ?>
                                    <form action="<?php echo e(route('faq.update', $faq->id)); ?>" method="POST"
                                        enctype="multipart/form-data" class="needs-validation" novalidate>
                                        <?php echo method_field('PUT'); ?>
                                    <?php else: ?>
                                        <form action="<?php echo e(route('faq.store')); ?>" method="POST"
                                            enctype="multipart/form-data" class="needs-validation" novalidate>
                                <?php endif; ?>

                                <?php echo csrf_field(); ?>

                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Question</label>
                                        <input type="text" class="form-control" name="question"
                                            <?php if(isset($faq)): ?> value="<?php echo e(old('question', optional($faq)->question)); ?>" <?php endif; ?> required>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Answer</label>
                                        <textarea class="ckeditor" name="answer">
                                            <?php if(isset($faq)): ?><?php echo e(old('answer', $faq->answer)); ?><?php endif; ?>
                                        </textarea>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "<?php echo e(route('faqstatus')); ?>",
                    data: {
                        'status': status,
                        'id': id
                    },
                    success: function(data) {
                        {

                            $.NotificationApp.send("Success", data.success, "top-right",
                                "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/backend/faq/index.blade.php ENDPATH**/ ?>