<!DOCTYPE html>
<html lang="zxx">

<head>
    <!-- meta tags -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">

    <!-- title -->
    <title><?php echo e(env('APP_NAME')); ?> - Solar Energy</title>

    <!-- css -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/all-fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/magnific-popup.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/nice-select.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/style.css')); ?>">
    <?php
        $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
    ?>
    <?php if(isset($setup->favicon)): ?>
        <link rel="icon" type="image/png" href="<?php echo e(asset('backend/images/website/' . $setup->favicon)); ?>">
    <?php endif; ?>

</head>

<body class="home-3">

    <!-- preloader -->
    <div class="preloader">
        <div class="loader-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <!-- preloader end -->

    <?php echo $__env->make('frontend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if($setup && $setup->contact_phone_1): ?>
        <a href="tel:+91-<?php echo e($setup->contact_phone_1); ?>" class="float1" target="_blank"> <i
                class="far fa-phone"></i> </a>
    <?php endif; ?>
    <?php if($setup && $setup->whatsapp_link): ?>
        <a href="https://api.whatsapp.com/send?phone=<?php echo e($setup->whatsapp_link); ?>&amp;text=<?php echo e(env('APP_NAME')); ?>"
            class="float" target="_blank">
            <i class="fab fa-whatsapp"></i> </a>
    <?php endif; ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>