<!DOCTYPE html>
<html lang="zxx">


<head>

    <!-- Metas -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <meta property="og:site_name" content="Decorist">
    <meta property="og:title" content="Online Interior Design - Top Interior Designers & Design Services | Decorist">
    <meta property="og:url" content="https://www.decorist.com/">
    <meta property="og:description"
          content="Decorist online interior design helps you transform any room in your home, in your personal style and at any budget. Work with top interior designers and decorators for one low flat fee!">
    <meta property="og:image" content="https://www.decorist.com/static/img/carousel-mid-1.jpg"/>
    <meta name="description"
          content="Decorist online interior design helps you transform any room in your home, in your personal style and at any budget. Work with top interior designers and decorators for one low flat fee!">
    <meta name="author" content="" />

    <!-- Title  -->
    <title>Kanishka (Licensed Clinical & Forensic Psychologist) - Counselling and Psychotherapy Services</title>

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('frontend/img/favicon.ico')); ?>" />

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900&amp;display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Teko:300,400,500,600,700&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Playfair+Display:400,500,600,700,800,900&amp;display=swap"
        rel="stylesheet">

    <!-- Plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/plugins.css')); ?>" />

    <!-- Core Style Css -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/style.css')); ?>" />

</head>

<body>

    <!-- ==================== Start progress-scroll-button ==================== -->

    <div class="progress-wrap cursor-pointer">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <!-- ==================== End progress-scroll-button ==================== -->


    <!-- ==================== Start cursor ==================== -->

    <div class="mouse-cursor cursor-outer"></div>
    <div class="mouse-cursor cursor-inner"></div>

    <!-- ==================== End cursor ==================== -->


    <!-- ==================== Start Navbar ==================== -->

    <nav class="navbar change navbar-expand-lg">
        <div class="container">

            <!-- Logo -->
            <a class="logo" href="/">
                <img src="<?php echo e(asset('../backend/images/homepage/'.$setup->header_logo)); ?>" onerror="this.onerror=null; this.src='<?php echo e(asset('frontend/img/logo-light.png')); ?>'">
            </a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="icon-bar"><i class="fas fa-bars"></i></span>
            </button>

            <!-- navbar links -->
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ml-auto">

                     <li class="nav-item">
                        <a class="nav-link" href="/">Home</a>
                    </li>

                    <li class="nav-item">
                         <a class="nav-link" href="<?php echo e(route('about')); ?>">About Us</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('services')); ?>">Services</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('blog')); ?>">Blog</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('contact')); ?>">Contact Us</a>
                    </li>
                </ul>
                <div class="social-icon">
                   <a href="<?php echo e($setup->linkedin_link); ?>"><i class="fab fa-linkedin"></i></a>
                   <a href="<?php echo e($setup->instagram_link); ?>"><i class="fab fa-instagram"></i></a>
                </div>

            </div>
        </div>
    </nav>

    <!-- ==================== End Navbar ==================== -->
<?php /**PATH C:\xampp\htdocs\kanishka_laravel\resources\views/frontend/include/header.blade.php ENDPATH**/ ?>