<?php $__env->startSection('content'); ?>
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="<?php echo e(route('service.create')); ?>" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-plus me-1"></i> Add Services
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Services</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped table-centered mb-0">
                                    <thead>
                                        <tr>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $__currentLoopData = $servicespage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="table-user">
                                                    <img id="blah"
                                                        src="<?php echo e(URL::asset('backend/images/services/' . $data->image)); ?>"
                                                        alt="your image"
                                                        onerror="this.onerror=null; this.src='<?php echo e(asset('backend/images/no_image.svg')); ?>'" />
                                                </td>
                                                <td><?php echo e($data->title); ?></td>
                                                <td>
                                                    <!-- Switch-->
                                                    <div>
                                                        <input type="checkbox" data-id="<?php echo e($data->id); ?>"
                                                            id="switch_<?php echo e($data->id); ?>" class="toggle-classs"
                                                            value="<?php echo e($data->id); ?>" <?php echo e($data->status ? 'checked' : ''); ?>

                                                            data-switch="success" />
                                                        <label for="switch_<?php echo e($data->id); ?>" data-on-label="Yes"
                                                            data-off-label="No" class="mb-0 d-block"></label>
                                                    </div>
                                                </td>
                                                <td class="table-action d-flex">

                                                    <a href="<?php echo e(route('service.edit', $data->id)); ?>" class="action-icon">
                                                        <i class="mdi mdi-pencil"></i></a>

                                                    <form action="<?php echo e(route('service.destroy', $data->id)); ?>" method="POST">
                                                        <?php echo method_field('DELETE'); ?>
                                                        <?php echo csrf_field(); ?>
                                                        <button class="btn text-danger btn-sm"
                                                            onclick="return areyousure();  " title="Delete"
                                                            class="action-icon">
                                                            <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="card">
                            <div class="card-body">
                                <?php if(isset($edit_service) && isset($edit_service->id)): ?>
                                    <form action="<?php echo e(route('service.update', $edit_service->id)); ?>" method="POST"
                                        enctype="multipart/form-data" class="needs-validation" novalidate>
                                        <?php echo method_field('PUT'); ?>
                                    <?php else: ?>
                                        <form action="<?php echo e(route('service.store')); ?>" method="POST"
                                            enctype="multipart/form-data" class="needs-validation" novalidate>
                                <?php endif; ?>
                                <?php echo csrf_field(); ?>

                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Title</label>
                                        <input type="text" class="form-control" name="title" required
                                            <?php if(isset($edit_service)): ?> value="<?php echo e(old('title', optional($edit_service)->title)); ?>" <?php endif; ?>>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Website Link</label>
                                        <input type="text" class="form-control" name="link"
                                            <?php if(isset($edit_service)): ?> value="<?php echo e(old('link', optional($edit_service)->link)); ?>" <?php endif; ?>>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file" id="image" name="image" class="form-control">
                                        <?php if(isset($edit_service)): ?>
                                            <img id="img"
                                                src="<?php echo e(URL::asset('backend/images/services/' . old('image', optional($edit_service)->image))); ?>"
                                                onerror="this.onerror=null; this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'"
                                                style="width: 35%;" />
                                        <?php else: ?>
                                            <img class="mt-2" id="img"
                                                src="<?php echo e(asset('backend/images/no_image.png')); ?>"
                                                onerror="this.onerror=null;this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'"
                                                height="100px" width="100px">
                                        <?php endif; ?>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Description</label>
                                        <textarea class="ckeditor" name="description"
                                            <?php if(isset($servicespage)): ?> value="<?php echo e(old('description')); ?>" <?php endif; ?>>
                                            <?php if(isset($edit_service)): ?>
                                            <?php echo $edit_service->description; ?>

                                            <?php endif; ?>
                                        </textarea>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        image.onchange = evt => {
            const [file] = image.files
            if (file) {
                img.src = URL.createObjectURL(file)
            }
        }
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "<?php echo e(route('servicestatus')); ?>",
                    data: {
                        'status': status,
                        'id': id
                    },
                    success: function(data) {
                        {

                            $.NotificationApp.send("Success", data.success, "top-right",
                                "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tpl-groups\resources\views/backend/services/index.blade.php ENDPATH**/ ?>