<?php $__env->startSection('content'); ?>
    <div class="search-overlay">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-layer"></div>
                <div class="search-close">
                    <span class="search-close-line"></span>
                    <span class="search-close-line"></span>
                </div>
                <div class="search-form">
                    <form>
                        <input type="text" class="input-search" placeholder="Search here...">
                        <button type="submit"><i class="bx bx-search"></i></button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="inner-banner" id="banner-opc">
        <div class="container">
            <div class="inner-title text-center">
                <h3>Company Policy</h3>
                <ul>
                    <li>
                        <a href="<?php echo e(route('home')); ?>">Home</a>
                    </li>
                    <li>
                        <i class="bx bx-chevrons-right"></i>
                    </li>
                    <li>Company Policy</li>
                </ul>
            </div>
        </div>
        <div class="inner-shape">
            <img src="<?php echo e(asset('frontend/images/shape/inner-shape.png')); ?>" alt="Images">
        </div>
    </div>


    <div class="terms-conditions-area pt-100 pb-70">
        <div class="container">
            <div class="section-title text-center">
                <h2><?php echo e(env('APP_NAME')); ?> Policy</h2>
            </div>
            <div class="row pt-45">
                <div class="col-lg-12">
                    
                    <div class="single-content">
                        <h3>Our Commitment to Excellence</h3>
                        <p>
                            At Analysis Research Management Services (ARMS), we are dedicated to fostering a
                            workplace that values excellence, integrity, and collaboration. Our policies are designed to
                            create an environment where every team member can thrive and contribute to groundbreaking
                            research in clinical trials.
                        </p>
                    </div>
                    <div class="single-content">
                        <h3>Core Values</h3>
                        <div class="service-article">
                            <div class="service-article-content">
                                <h5>01. Integrity</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        We uphold the highest standards of ethical conduct in all our research
                                        activities.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Transparency and honesty are the cornerstones of our interactions with
                                        stakeholders.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>02. Quality</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Commitment to delivering the highest quality results in every clinical
                                        trial.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Continuous improvement through rigorous training and adherence to Good
                                        Clinical Practice (GCP) guidelines.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>03. Quality</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Encouraging teamwork and open communication across all levels of the
                                        organization.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Fostering partnerships with sponsors, CROs, and the local community to
                                        advance clinical research.
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="single-content">
                        <h3>Inclusive and Supportive Environment</h3>
                        <div class="service-article">
                            <div class="service-article-content">
                                <h5>01. Diversity and Inclusion</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Promoting a culture of diversity where different perspectives are valued.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Ensuring equal opportunities for all employees regardless of their background.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>02. Professional Development</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Offering continuous learning and development opportunities to enhance skills
                                        and knowledge.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Providing access to the latest research tools and technologies.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>03. Work-Life Balance</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Supporting flexible work arrangements to help employees maintain a healthy
                                        work-life balance.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Encouraging regular breaks and wellness activities to promote overall well-
                                        being.
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="single-content">
                        <h3>Health and Safety</h3>
                        <div class="service-article">
                            <div class="service-article-content">
                                <h5>01. Safe Work Environment</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Maintaining a safe and healthy workplace by adhering to all safety regulations
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Regular training on safety protocols and emergency procedures.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>02. Employee Well-being</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Offering comprehensive health benefits and wellness programs.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Providing resources for mental health support and counseling.
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="single-content">
                        <h3>Ethical Conduct and Compliance</h3>
                        <div class="service-article">
                            <div class="service-article-content">
                                <h5>01. Regulatory Adherence</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Strict compliance with all regulatory requirements and ethical guidelines in
                                        clinical research.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Regular audits and reviews to ensure ongoing adherence to standards.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>02. Confidentiality</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Ensuring the confidentiality and security of all research data.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Protecting the privacy of patients and participants involved in our trials.
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="single-content">
                        <h3>Innovation and Sustainability</h3>
                        <div class="service-article">
                            <div class="service-article-content">
                                <h5>01. Innovative Practices</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Embracing new technologies and methodologies to enhance research
                                        efficiency.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Encouraging creative problem-solving and innovation in all aspects of our
                                        work.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>02. Sustainability</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Implementing eco-friendly practices to minimize our environmental impact.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Promoting sustainability in our operations and research activities.
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="single-content">
                        <h3>Open Door Policy</h3>
                        <div class="service-article">
                            <div class="service-article-content">
                                <h5>01. Communication</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Encouraging open dialogue between employees and management.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Providing channels for feedback, suggestions, and concerns.
                                    </li>
                                </ul>
                            </div>
                            <div class="service-article-content">
                                <h5>02. Conflict Resolution</h5>
                                <ul class="service-article-list service-article-rs pt-2">
                                    <li><i class="bx bxs-check-circle"></i>
                                        Addressing conflicts promptly and fairly.
                                    </li>
                                    <li><i class="bx bxs-check-circle"></i>
                                        Promoting a respectful and harmonious workplace.
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="single-content">
                        <p>
                            At ARMS, we believe that our greatest asset is our people. By creating a supportive and
                            dynamic workplace, we empower our team to achieve excellence in clinical research and
                            make meaningful contributions to the advancement of healthcare.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\analysis_service\resources\views/frontend/company_policy.blade.php ENDPATH**/ ?>