<?php
    $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
?>
<div class="wrapper">
    <div class="leftside-menu">

        <!-- LOGO -->
        <a href="/admin/dashboard" class="logo text-center logo-light" style="background: #fff !important;">
            <?php if($setup && $setup->header_logo): ?>
                <span class="logo-lg" style="background: #108abd;">
                    <img src="<?php echo e(asset('backend/images/website/' . $setup->header_logo)); ?>"
                        onerror="this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'; this.onerror='';" alt=""
                        style="width: 150px; height: 60px;">
                </span>
            <?php endif; ?>
            <span class="logo-sm">
                <img src="<?php echo e(asset('frontend/img/favicon.png')); ?>" alt="" height="30">
            </span>
        </a>

        <div class="h-100" id="leftside-menu-container" data-simplebar>

            <!--- Sidemenu -->
            <ul class="side-nav">

                <li class="side-nav-item">
                    <a href="/admin/dashboard" class="side-nav-link">
                        <i class="uil-home-alt"></i>
                        <span> Dashboards </span>
                    </a>
                </li>

                


                <li class="side-nav-item">
                    <a data-bs-toggle="collapse" href="#courses" aria-expanded="false" aria-controls="courses"
                        class="side-nav-link">
                        <i class="uil-copy-alt"></i>
                        <span> Services </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="courses">
                        <ul class="side-nav-second-level">
                            <li>
                                <a href="<?php echo e(route('service-category.index')); ?>">Category</a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('service.index')); ?>">All Services</a>
                            </li>
                        </ul>
                    </div>
                </li>

                

                <li class="side-nav-item">
                    <a href="<?php echo e(route('slider.index')); ?>" class="side-nav-link">
                        <i class="uil uil-image"></i>
                        <span> Sliders </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('gallery.index')); ?>" class="side-nav-link">
                        <i class="uil uil-image"></i>
                        <span> Gallery </span>
                    </a>
                </li>

                

                

                <li class="side-nav-item">
                    <a href="<?php echo e(route('client.index')); ?>" class="side-nav-link">
                        <i class="uil-calender"></i>
                        <span> Client </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('team.index')); ?>" class="side-nav-link">
                        <i class="uil-calender"></i>
                        <span> Team </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('testimonial.index')); ?>" class="side-nav-link">
                        <i class="uil-calender"></i>
                        <span> Testimonials </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('enquiry.index')); ?>" class="side-nav-link">
                        <i class="uil-envelope"></i>
                        <span> Enquiry </span>
                    </a>
                </li>

                <li class="side-nav-item">
                    <a href="<?php echo e(route('website.index')); ?>" class="side-nav-link">
                        <i class="uil-globe"></i>
                        <span> Website Setup </span>
                    </a>
                </li>

            </ul>
            <!-- End Sidebar -->

            <div class="clearfix"></div>

        </div>
        <!-- Sidebar -left -->

    </div>
<?php /**PATH C:\xampp\htdocs\econsultancy\resources\views/backend/layouts/sidebar.blade.php ENDPATH**/ ?>