<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title><?php echo e(env('APP_NAME')); ?> || Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
    <meta content="Coderthemes" name="author" />
    <?php
        $setup = App\Models\WebsiteSetup::orderBy('id', 'desc')->where('delete_status', '0')->first();
    ?>
    <?php if(isset($setup->favicon)): ?>
        <link rel="icon" type="image/png" href="<?php echo e(asset('backend/images/website/' . $setup->favicon)); ?>">
    <?php endif; ?>

    <!-- third party css -->
    <link href="<?php echo e(asset('backend/css/vendor/jquery-jvectormap-1.2.2.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- third party css end -->

    <!-- App css -->
    <link href="<?php echo e(asset('backend/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('backend/css/app.min.css')); ?>" rel="stylesheet" type="text/css" id="app-style" />

</head>

<body class="loading authentication-bg" data-layout-config='{"darkMode":false}'>

    <div class="account-pages pt-2 pt-sm-4 b-sm-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-4 col-lg-5">
                    <div class="card">

                        <!-- Logo -->
                        <?php if($setup && $setup->logo): ?>
                            <div class="card-header pt-2 pb-2 text-center">
                                <a href="/">
                                    <span> <img src="<?php echo e(asset('backend/images/website/' . $setup->logo)); ?>"
                                            onerror="this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'; this.onerror='';"
                                            alt="" height="60"></span>
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="card-body p-4">

                            <div class="text-center w-75 m-auto">
                                <h4 class="text-dark-50 text-center pb-0 fw-bold">Sign In</h4>
                            </div>

                            <form action="<?php echo e(route('adminLogin')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <label for="emailaddress" class="form-label">Email address</label>
                                    <input class="form-control" type="email" id="emailaddress" required=""
                                        placeholder="Enter your email" name="email">
                                </div>

                                <div class="mb-3">
                                    <a href="pages-recoverpw.html" class="text-muted float-end"><small>Forgot your
                                            password?</small></a>
                                    <label for="password" class="form-label">Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="password" class="form-control"
                                            placeholder="Enter your password" name="password">
                                        <div class="input-group-text" data-password="false">
                                            <span class="password-eye"></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3 mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="checkbox-signin" checked>
                                        <label class="form-check-label" for="checkbox-signin">Remember me</label>
                                    </div>
                                </div>

                                <div class="mb-3 mb-0 text-center">
                                    <button class="btn btn-primary" type="submit"> Log In </button>
                                </div>

                            </form>
                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->

                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>


    <script src="<?php echo e(asset('backend/js/vendor.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/pages/demo.toastr.js')); ?>"></script>

    <?php if(session()->has('error')): ?>
        <script>
            $.NotificationApp.send("Error", "<?php echo e(session()->get('error')); ?>", "top-right", "rgba(0,0,0,0.2)", "error")
        </script>
    <?php endif; ?>

    <?php if(session()->has('success')): ?>
        <script>
            $.NotificationApp.send("Success", "<?php echo e(session()->get('success')); ?>", "top-right", "rgba(0,0,0,0.2)", "success")
        </script>
    <?php endif; ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\tpl-groups\resources\views/backend/login.blade.php ENDPATH**/ ?>