<?php
    $setup = App\Models\WebsiteSetup::where('delete_status', '0')->first();
    $services = App\Models\Services::where('delete_status', '0')->where('status', '1')->get();
?>

<!-- header start -->
<header id="masthead" class="header prt-header-style-01">
    <!-- topbar -->
    <div class="top_bar prt-topbar-wrapper text-base-white clearfix">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="d-flex flex-row align-items-start justify-content-start">
                        <div class="top_bar_contact_item mob-d-none">
                            <span class="text-base-skin"></span><a
                                href="tel:+91-<?php echo e($setup ? $setup->contact_phone_1 : ''); ?>"><i
                                    class="flaticon-phone-call"></i>&nbsp;
                                +91-<?php echo e($setup ? $setup->contact_phone_1 : ''); ?></a>,
                                <a
                                href="tel:+91-<?php echo e($setup ? $setup->contact_phone_2 : ''); ?>">
                                +91-<?php echo e($setup ? $setup->contact_phone_2 : ''); ?></a>
                        </div>
                        <div class="top_bar_contact_item">
                            <span class="text-base-skin"></span><a
                                href="mailto:<?php echo e($setup ? $setup->contact_email_1 : ''); ?>"><i
                                    class="flaticon-email"></i>&nbsp; <?php echo e($setup ? $setup->contact_email_1 : ''); ?></a>
                        </div>
                        <div class="top_bar_contact_item ms-auto">
                            <span class="text-base-skin"></span><a
                                href="#"><i
                                    class="fa fa-user-circle-o"></i>&nbsp; Login</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- topbar end -->
    <div id="site-header-menu" class="site-header-menu">
        <div class="site-header-menu-inner prt-stickable-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12 px-5">
                        <!--site-navigation -->
                        <div class="site-navigation d-flex align-items-center justify-content-between">
                            <!-- site-branding -->
                            <div class="site-branding me-auto">
                                <h1>
                                    <a class="home-link" href="/">
                                        <img src="<?php echo e($setup ? asset('backend/images/website/' . $setup->header_logo) : ''); ?>"
                                            width="220"
                                            onerror="this.src='<?php echo e(asset('frontend/images/logo.png')); ?>';this.onerror='';">
                                    </a>
                                </h1>
                            </div><!-- site-branding end -->
                            <!-- header_extra -->
                            <div class="header_extra d-flex flex-row align-items-center justify-content-end">
                                <div class="widget_social">
                                    <div class="social-icons social-hover">
                                        <ul class="social-icons d-flex">
                                            <li>
                                                <a class="prt-social-instagram"
                                                    href="<?php echo e($setup ? $setup->instagram_link : ''); ?>" target="_blank"><i
                                                        class="icon-instagram"></i></a>
                                            </li>
                                            <li>
                                                <a class="prt-social-facebook" href="<?php echo e($setup ? $setup->facebook_link : ''); ?>"
                                                    target="_blank"><i class="icon-facebook"></i></a>
                                            </li>
                                            <li>
                                                <a class="prt-social-twitter" href="<?php echo e($setup ? $setup->twitter_link : ''); ?>"
                                                    target="_blank"><i class="icon-twitter"></i></a>
                                            </li>

                                            <li>
                                                <a class="prt-social-linkedin" href="<?php echo e($setup ? $setup->linkedin_link : ''); ?>"
                                                    target="_blank"><i class="icon-linkedin"></i></a>
                                            </li>
                                            <li>
                                                <a class="prt-social-youtube" href="<?php echo e($setup ? $setup->youtube_link : ''); ?>"
                                                    target="_blank"><i class="icon-youtube"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <!-- header_extra end -->
                        </div><!-- site-navigation end-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- site-header-menu -->
    <div id="site-header-menu" class="site-header-menu" style="background: #00b36129;">
        <div class="site-header-menu-inner prt-stickable-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <!--site-navigation -->
                        <div class="site-navigation d-flex align-items-center justify-content-center">
                            <div class="btn-show-menu-mobile menubar menubar--squeeze">
                                <span class="menubar-box">
                                    <span class="menubar-inner"></span>
                                </span>
                            </div>
                            <!-- menu -->
                            <nav class="main-menu menu-mobile" id="menu">
                                <ul class="menu">
                                    <li class="mega-menu-item  <?php if(Route::currentRouteName() == 'home'): ?> active <?php endif; ?>">
                                        <a href="/">Home</a>
                                    </li>

                                    <li class="mega-menu-item <?php if(Route::currentRouteName() == 'about' || Route::currentRouteName() == 'team'): ?> active <?php endif; ?>">
                                        <a href="#" class="mega-menu-link">About Us</a>
                                        <ul class="mega-submenu">
                                            <li><a href="<?php echo e(route('about')); ?>">About TPL Groups</a></li>
                                            <li><a href="<?php echo e(route('team')); ?>">Director Messages</a></li>
                                        </ul>
                                    </li>

                                    <li class="mega-menu-item <?php if(Route::currentRouteName() == 'service-detail'): ?> active <?php endif; ?>">
                                        <a href="#" class="mega-menu-link">Business</a>
                                        <ul class="mega-submenu">
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="<?php echo e(route('service-detail', $service->slug)); ?>"><?php echo e($service->title); ?></a></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </li>

                                    <li>
                                        <a href="#">Companies</a>
                                    </li>

                                    

                                    <li class="mega-menu-item <?php if(Route::currentRouteName() == 'blog' || Route::currentRouteName() == 'blogs'): ?> active <?php endif; ?>">
                                        <a href="<?php echo e(route('blog')); ?>">Blogs</a>
                                    </li>

                                    <li>
                                        <a href="#">Investors</a>
                                    </li>

                                    <li class="mega-menu-item <?php if(Route::currentRouteName() == 'newsroom' || Route::currentRouteName() == 'newsrooms'): ?> active <?php endif; ?>">
                                        <a href="<?php echo e(route('newsroom')); ?>">News Room</a>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('career')); ?>">Careers</a>
                                    </li>

                                    <li class="mega-menu-item  <?php if(Route::currentRouteName() == 'contact'): ?> active <?php endif; ?>">
                                        <a href="<?php echo e(route('contact')); ?>">Contact Us</a>
                                    </li>
                                </ul>
                            </nav><!-- menu end -->
                            <!-- header_extra -->
                            <div class="header_extra d-flex flex-row align-items-center justify-content-end">
                                <div class="header_btn">
                                    <a class="prt-btn prt-btn-size-sm prt-btn-shape-rounded prt-btn-style-fill prt-btn-color-dark"
                                        href="#">Book Now </a>
                                </div>
                            </div>
                            <!-- header_extra end -->
                        </div><!-- site-navigation end-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- site-header-menu end-->
</header>
<!-- header end -->
<?php /**PATH C:\xampp\htdocs\tpl-groups\resources\views/frontend/layouts/header.blade.php ENDPATH**/ ?>