<?php $__env->startSection('content'); ?>
    <main class="main">

        <!-- breadcrumb -->
        <div class="site-breadcrumb" style="background: url('<?php echo e(asset('frontend/img/breadcrumb/01.jpg')); ?>')">
            <div class="container">
                <h2 class="breadcrumb-title">Contact Us</h2>
                <ul class="breadcrumb-menu">
                    <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="active">Contact Us</li>
                </ul>
            </div>
        </div>
        <!-- breadcrumb end -->


        <!-- contact area -->
        <div class="contact-area py-50">
            <div class="container">
                <div class="contact-content">
                    <div class="row">
                        <?php if(isset($setup->contact_address)): ?>
                            <div class="col-md-4">
                                <div class="contact-info">
                                    <div class="icon">
                                        <i class="fal fa-map-location-dot"></i>
                                    </div>
                                    <div class="content">
                                        <h5>Office Address</h5>
                                        <p><?php echo e($setup->contact_address); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if($setup->contact_phone_1 || $setup->contact_phone_2): ?>
                            <div class="col-md-4">
                                <div class="contact-info">
                                    <div class="icon">
                                        <i class="fal fa-phone-volume"></i>
                                    </div>
                                    <div class="content">
                                        <h5>Call Us</h5>
                                        <?php if(isset($setup->contact_phone_1)): ?>
                                            <p><a
                                                    href="tel:+91-<?php echo e($setup->contact_phone_1); ?>">+91-<?php echo e($setup->contact_phone_1); ?></a>
                                            </p>
                                        <?php endif; ?>
                                        <?php if(isset($setup->contact_phone_2)): ?>
                                            <p><a
                                                    href="tel:+91-<?php echo e($setup->contact_phone_2); ?>">+91-<?php echo e($setup->contact_phone_2); ?></a>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if($setup->contact_email_1 || $setup->contact_email_2): ?>
                            <div class="col-md-4">
                                <div class="contact-info">
                                    <div class="icon">
                                        <i class="fal fa-envelopes"></i>
                                    </div>
                                    <div class="content">
                                        <h5>Email Us</h5>
                                        <?php if(isset($setup->contact_email_1)): ?>
                                            <p><a href="mailto:<?php echo e($setup->contact_email_1); ?>"><?php echo e($setup->contact_email_1); ?></a>
                                            </p>
                                        <?php endif; ?>
                                        <?php if(isset($setup->contact_email_2)): ?>
                                            <p><a href="mailto:<?php echo e($setup->contact_email_2); ?>"><?php echo e($setup->contact_email_2); ?></a>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="contact-form-wrap">
                    <div class="row align-items-center g-4">
                        <div class="col-lg-6">
                            <!-- map -->
                            <div style="overflow:hidden;resize:none;max-width:100%;width:600px;height:500px;">
                                <div id="canvas-for-googlemap" style="height:100%; width:100%;max-width:100%;"><iframe
                                        style="height:100%;width:100%;border:0;" frameborder="0"
                                        src="https://www.google.com/maps/embed/v1/place?q=S.19/31,+Varuna+Bridge,+Varanasi 221002+(U.P)&key=AIzaSyBFw0Qbyq9zTFTd-tUY6dZWTgaQzuU17R8"></iframe>
                                </div><a class="google-map-code-enabler" rel="nofollow"
                                    href="https://www.bootstrapskins.com/themes" id="get-data-for-map">premium bootstrap
                                    themes</a>
                                <style>
                                    #canvas-for-googlemap img.text-marker {
                                        max-width: none !important;
                                        background: none !important;
                                    }

                                    img {
                                        max-width: none
                                    }
                                </style>
                            </div>
                            <!-- map end -->
                        </div>
                        <div class="col-lg-6">
                            <div class="contact-form">
                                <div class="contact-form-header">
                                    <h2>Get In Touch</h2>
                                    <p>We’re here to help you harness the power of the sun! Whether you're interested in
                                        learning more about solar energy solutions, need assistance with installation, or
                                        have any other questions, we’d love to hear from you. </p>
                                </div>
                                <div class="form-message"></div>
                                <form method="post" action="<?php echo e(route('contactform')); ?>" id="contact-form">
                                    <?php echo csrf_field(); ?>
                                    <?php if($message = Session::get('success')): ?>
                                        <div class="alert alert-success" id="success-message">
                                            <p><?php echo e($message); ?></p>
                                        </div>
                                        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                                        <script>
                                            $(document).ready(function() {
                                                setTimeout(function() {
                                                    $('#success-message').fadeOut('slow');
                                                }, 3000);
                                            });
                                        </script>
                                    <?php endif; ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="form-icon">
                                                    <i class="far fa-user-tie"></i>
                                                    <input type="text" class="form-control" name="name"
                                                        value="<?php echo e(old('name')); ?>" placeholder="Your Name" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="form-icon">
                                                    <i class="far fa-envelope"></i>
                                                    <input type="email" class="form-control" name="email"
                                                        value="<?php echo e(old('email')); ?>" placeholder="Your Email" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="form-icon">
                                                    <i class="far fa-phone"></i>
                                                    <input type="text" class="form-control" name="number"
                                                        value="<?php echo e(old('number')); ?>" placeholder="Your Phone"
                                                        oninput="validatePhone(this)" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="form-icon">
                                                    <i class="far fa-pen"></i>
                                                    <input type="text" class="form-control" name="subject"
                                                        value="<?php echo e(old('subject')); ?>" placeholder="Your Subject" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-icon">
                                            <i class="far fa-comment-lines"></i>
                                            <textarea name="message" cols="30" rows="4" class="form-control" placeholder="Write Your Message">
                                                <?php echo e(old('message')); ?>

                                            </textarea>
                                        </div>
                                    </div>
                                    <button type="submit" class="theme-btn">Send
                                        Message <i class="far fa-paper-plane"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end contact area -->

    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/frontend/contact.blade.php ENDPATH**/ ?>