<?php $__env->startSection('content'); ?>
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <a href="<?php echo e(route('site.create')); ?>" class="btn btn-sm btn-dark waves-effect">
                                        <i class="dripicons-plus me-1"></i> Add Site
                                    </a>
                                </ol>
                            </div>
                            <h4 class="page-title">Site</h4>
                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-striped table-centered mb-0">
                                    <thead>
                                        <tr>
                                            <th>Image</th>
                                            <th>Site Name</th>
                                            <th>Location</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $__currentLoopData = $site; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="table-user">
                                                    <img id="blah"
                                                        src="<?php echo e(URL::asset('backend/images/site/' . $data->image)); ?>"
                                                        alt="your image"
                                                        onerror="this.onerror=null; this.src='<?php echo e(asset('backend/images/no_image.svg')); ?>'" />
                                                </td>
                                                <td><?php echo e($data->name); ?></td>
                                                <td><?php echo e($data->location); ?></td>
                                                <td>
                                                    <!-- Switch-->
                                                    <div>
                                                        <input type="checkbox" data-id="<?php echo e($data->id); ?>"
                                                            id="switch_<?php echo e($data->id); ?>" class="toggle-classs"
                                                            value="<?php echo e($data->id); ?>" <?php echo e($data->status ? 'checked' : ''); ?>

                                                            data-switch="success" />
                                                        <label for="switch_<?php echo e($data->id); ?>" data-on-label="Yes"
                                                            data-off-label="No" class="mb-0 d-block"></label>
                                                    </div>
                                                </td>
                                                <td class="table-action d-flex">

                                                    <a href="<?php echo e(route('site.edit', $data->id)); ?>" class="action-icon">
                                                        <i class="mdi mdi-pencil"></i></a>

                                                    <form action="<?php echo e(route('site.destroy', $data->id)); ?>" method="POST">
                                                        <?php echo method_field('DELETE'); ?>
                                                        <?php echo csrf_field(); ?>
                                                        <button class="btn text-danger btn-sm"
                                                            onclick="return areyousure();  " title="Delete"
                                                            class="action-icon">
                                                            <i class="mdi mdi-delete" aria-hidden="true"></i> </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="card">
                            <div class="card-body">
                                <?php if(isset($edit_site) && isset($edit_site->id)): ?>
                                    <form action="<?php echo e(route('site.update', $edit_site->id)); ?>" method="POST"
                                        enctype="multipart/form-data" class="needs-validation" novalidate>
                                        <?php echo method_field('PUT'); ?>
                                    <?php else: ?>
                                        <form action="<?php echo e(route('site.store')); ?>" method="POST"
                                            enctype="multipart/form-data" class="needs-validation" novalidate>
                                <?php endif; ?>
                                <?php echo csrf_field(); ?>

                                <div class="row">

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Site Name</label>
                                        <input type="text" class="form-control" name="name" required
                                            <?php if(isset($edit_site)): ?> value="<?php echo e(old('name', optional($edit_site)->name)); ?>" <?php endif; ?>>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Study Indication</label>
                                        <input type="text" class="form-control" name="study_indications" required
                                            <?php if(isset($edit_site)): ?> value="<?php echo e(old('study_indications', optional($edit_site)->study_indications)); ?>" <?php endif; ?>>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Location</label>
                                        <input type="text" class="form-control" name="location"
                                            <?php if(isset($edit_site)): ?> value="<?php echo e(old('location', optional($edit_site)->location)); ?>" <?php endif; ?>>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">Image</label>
                                        <input type="file" id="image" name="image" class="form-control">
                                        <?php if(isset($edit_site)): ?>
                                            <img id="img"
                                                src="<?php echo e(URL::asset('backend/images/site/' . old('image', optional($edit_site)->image))); ?>"
                                                onerror="this.onerror=null; this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'"
                                                style="width: 35%;" />
                                        <?php else: ?>
                                            <img class="mt-2" id="img"
                                                src="<?php echo e(asset('backend/images/no_image.png')); ?>"
                                                onerror="this.onerror=null;this.src='<?php echo e(asset('backend/images/no_image.png')); ?>'"
                                                height="100px" width="100px">
                                        <?php endif; ?>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <label class="form-label">About Site</label>
                                        <textarea class="ckeditor" name="description"
                                            <?php if(isset($site)): ?> value="<?php echo e(old('description')); ?>" <?php endif; ?>>
                                            <?php if(isset($edit_site)): ?>
                                            <?php echo $edit_site->description; ?>

                                            <?php endif; ?>
                                        </textarea>
                                    </div>

                                    <div class="mb-3 col-md-12">
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                    </div>

                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- container -->
    </div>
    <!-- content -->

    </div>

    </div>
    <!-- END wrapper -->

    <script>
        image.onchange = evt => {
            const [file] = image.files
            if (file) {
                img.src = URL.createObjectURL(file)
            }
        }
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(function() {
            $('.toggle-classs').click(function() {
                var status = $(this).prop('checked') == true ? 1 : 0;
                var id = $(this).attr('value');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: "<?php echo e(route('sitestatus')); ?>",
                    data: {
                        'status': status,
                        'id': id
                    },
                    success: function(data) {
                        {

                            $.NotificationApp.send("Success", data.success, "top-right",
                                "rgba(0,0,0,0.2)", "success")
                        }
                    }
                });
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\auto-enterprises\resources\views/backend/site/index.blade.php ENDPATH**/ ?>